/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.loader.compiler;

import com.ovopark.dc.util.ClassUtil;
import com.ovopark.dc.util.ReflectUtil;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.NotFoundException;

public class ClassGenerator {
    private static final AtomicLong CLASS_NAME_COUNTER = new AtomicLong(0L);
    private static Map<ClassLoader, ClassPool> CLASS_LOADER_POOL = new HashMap<ClassLoader, ClassPool>();
    private ClassPool pool;
    private String className;
    private String supperClassName;
    private Set<String> interfaceSet;
    private List<String> importClass;
    private Map<String, String> importName = new HashMap<String, String>();
    private List<String> fields;
    private List<String> methods;
    private CtClass ctClass;
    private List<String> constructorList;
    private boolean defaultConstructor = false;

    public ClassGenerator(ClassPool classPool) {
        this.pool = classPool;
    }

    public static ClassGenerator newInstance(ClassLoader classLoader) {
        return new ClassGenerator(ClassGenerator.getClassPool(classLoader));
    }

    public static ClassPool getClassPool(ClassLoader classLoader) {
        if (classLoader == null) {
            return ClassPool.getDefault();
        }
        ClassPool pool = CLASS_LOADER_POOL.get(classLoader);
        if (pool == null) {
            pool = new ClassPool(true);
            pool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
            CLASS_LOADER_POOL.put(classLoader, pool);
        }
        return pool;
    }

    public void addInterface(Class<?> interfaceClass) {
        this.addInterface(interfaceClass.getName());
    }

    public void addInterface(String interfaceName) {
        if (this.interfaceSet == null) {
            this.interfaceSet = new HashSet<String>();
        }
        this.interfaceSet.add(interfaceName);
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public void setSuperClass(Class<?> clazz) {
        this.supperClassName = clazz.getName();
    }

    public void setSuperClass(String name) {
        this.supperClassName = name;
    }

    public void setDefaultConstructor() {
        this.defaultConstructor = true;
    }

    public void addField(String field) {
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
        }
        this.fields.add(field);
    }

    public void addMethod(String method) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        this.methods.add(method);
    }

    public void addMethod(String name, int mod, Class<?> resultType, Class<?>[] params, Class<?>[] exceptions, String body) {
        int index;
        StringBuilder method = new StringBuilder();
        method.append(this.getModify(mod)).append(" ").append(ReflectUtil.getName(resultType)).append(" ").append(name);
        method.append("(");
        for (index = 0; index < params.length; ++index) {
            Class<?> param = params[index];
            method.append(ReflectUtil.getName(param)).append(" ");
            method.append("arg").append(params.length);
            if (index >= params.length - 1) continue;
            method.append(",");
        }
        method.append(")");
        if (exceptions.length > 0) {
            method.append(" throws ");
            for (index = 0; index < exceptions.length; ++index) {
                Class<?> exception = exceptions[index];
                method.append(exception.getName());
                if (index >= exceptions.length - 1) continue;
                method.append(",");
            }
        }
        method.append("{");
        method.append(body).append("}");
        this.addMethod(method.toString());
    }

    private String getModify(int mod) {
        StringBuilder sb = new StringBuilder();
        if (Modifier.isPublic((int)mod)) {
            sb.append("public");
        }
        if (Modifier.isProtected((int)mod)) {
            sb.append("protected");
        }
        if (Modifier.isPrivate((int)mod)) {
            sb.append("private");
        }
        if (Modifier.isStatic((int)mod)) {
            sb.append(" static");
        }
        if (Modifier.isVolatile((int)mod)) {
            sb.append(" volatile");
        }
        return sb.toString();
    }

    public void release() {
        if (this.fields != null) {
            this.fields.clear();
        }
        if (this.methods != null) {
            this.methods.clear();
        }
        if (this.ctClass != null) {
            this.ctClass.detach();
        }
        if (this.constructorList != null) {
            this.constructorList.clear();
        }
    }

    public Class<?> toClass() {
        return this.toClass(ClassUtil.getClassLoader(ClassGenerator.class), this.getClass().getProtectionDomain());
    }

    public Class<?> toClass(ClassLoader classLoader) {
        return this.toClass(classLoader, this.getClass().getProtectionDomain());
    }

    public Class<?> toClass(ClassLoader classLoader, ProtectionDomain protectionDomain) {
        if (this.ctClass != null) {
            this.ctClass.detach();
        }
        long id = CLASS_NAME_COUNTER.getAndIncrement();
        try {
            CtClass superClass;
            CtClass ctClass = superClass = this.supperClassName == null ? null : this.pool.get(this.supperClassName);
            if (this.className == null) {
                this.className = superClass == null || Modifier.isPublic((int)superClass.getModifiers()) ? ClassGenerator.class.getName() : this.supperClassName + "$sc" + id;
            }
            this.ctClass = this.pool.makeClass(this.className);
            if (superClass != null) {
                this.ctClass.setSuperclass(superClass);
            }
            if (this.interfaceSet != null) {
                for (String interfaceName : this.interfaceSet) {
                    this.ctClass.addInterface(this.pool.get(interfaceName));
                }
            }
            if (this.importClass != null) {
                for (String importData : this.importClass) {
                    this.pool.importPackage(importData);
                }
            }
            if (this.fields != null) {
                for (String name : this.fields) {
                    this.ctClass.addField(CtField.make((String)name, (CtClass)this.ctClass));
                }
            }
            if (this.methods != null) {
                for (String method : this.methods) {
                    this.ctClass.addMethod(CtMethod.make((String)method, (CtClass)this.ctClass));
                }
            }
            if (this.defaultConstructor) {
                CtConstructor defaultConstructor = CtNewConstructor.defaultConstructor((CtClass)this.ctClass);
                this.ctClass.addConstructor(defaultConstructor);
            }
            return this.ctClass.toClass(classLoader, protectionDomain);
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setConstructor(int mod, Class<?>[] params, Class<?>[] exceptions, String body) {
        int index;
        StringBuilder method = new StringBuilder();
        method.append(this.getModify(mod)).append(" ").append("<init>");
        method.append("(");
        for (index = 0; index < params.length; ++index) {
            Class<?> param = params[index];
            method.append(ReflectUtil.getName(param)).append(" ");
            method.append("arg").append(params.length);
            if (index >= params.length - 1) continue;
            method.append(",");
        }
        method.append(")");
        if (exceptions.length > 0) {
            method.append(" throws ");
            for (index = 0; index < exceptions.length; ++index) {
                Class<?> exception = exceptions[index];
                method.append(exception.getName());
                if (index >= exceptions.length - 1) continue;
                method.append(",");
            }
        }
        method.append("{");
        method.append(body).append("}");
        this.addConstructor(method.toString());
    }

    public void addConstructor(String constructor) {
        if (this.constructorList == null) {
            this.constructorList = new ArrayList<String>();
        }
        this.constructorList.add(constructor);
    }

    public void addImport(String importClass) {
        int pi = importClass.lastIndexOf(46);
        if (pi > 0) {
            String pkgName = importClass.substring(0, pi);
            if (this.importClass == null) {
                this.importClass = new ArrayList<String>();
            }
            this.importClass.add(pkgName);
            if (!importClass.endsWith("*")) {
                this.importName.put(importClass.substring(pi + 1), importClass);
            }
        }
    }
}

