/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.loader.compiler;

import com.ovopark.dc.loader.compiler.AbstractCompiler;
import com.ovopark.dc.loader.compiler.ClassGenerator;
import com.ovopark.dc.util.ClassUtil;
import com.ovopark.dc.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavassistCompiler
extends AbstractCompiler {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("import\\s+([\\w\\.\\*]+);\n");
    private static final Pattern EXTEND_PATTERN = Pattern.compile("\\s+extends\\s+([\\w\\.]+)[^\\{]*\\{\\s*\n");
    private static final Pattern IMPLEMENT_PATTERN = Pattern.compile("\\s+implements\\s+([\\w\\.]+)\\s*\\{\\s*\n");
    private static final Pattern METHOD_PATTERN = Pattern.compile("\n(private|public|protected)\\s+");
    private static final Pattern FIELD_PATTERN = Pattern.compile("[^\n]+=[^\n]+;");

    @Override
    protected Class<?> doCompile(String className, String code) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ClassGenerator classGenerator = ClassGenerator.newInstance(classLoader);
        classGenerator.setClassName(className);
        Matcher matcher = IMPORT_PATTERN.matcher(code);
        while (matcher.find()) {
            classGenerator.addImport(matcher.group(1).trim());
        }
        matcher = EXTEND_PATTERN.matcher(code);
        if (matcher.find()) {
            classGenerator.setSuperClass(matcher.group(1).trim());
        }
        if ((matcher = IMPLEMENT_PATTERN.matcher(code)).find()) {
            String[] allInterface;
            for (String interfaceName : allInterface = matcher.group(1).trim().split("\\,")) {
                classGenerator.addInterface(interfaceName);
            }
        }
        String body = code.substring(code.indexOf("{") + 1, code.length() - 1);
        String[] methods = METHOD_PATTERN.split(body);
        String simpleClassName = ClassUtil.getSimpleName((String)className);
        for (String method : methods) {
            if (method.startsWith(simpleClassName)) {
                classGenerator.addConstructor("public " + method);
                continue;
            }
            if (FIELD_PATTERN.matcher(method).matches()) {
                classGenerator.addField("private " + method);
                continue;
            }
            if (!StringUtils.isNotEmpty((String)method)) continue;
            classGenerator.addMethod("public " + method);
        }
        return classGenerator.toClass(classLoader);
    }
}

