/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.loader.extension;

import com.ovopark.dc.loader.annotation.Adaptive;
import com.ovopark.dc.loader.annotation.Use;
import com.ovopark.dc.loader.compiler.Compiler;
import com.ovopark.dc.loader.compiler.JavassistCompiler;
import com.ovopark.dc.loader.extension.Holder;
import com.ovopark.dc.loader.factory.ExtensionFactory;
import com.ovopark.dc.loader.generate.AdaptiveGenerate;
import com.ovopark.dc.storage.broker.model.exception.ExtensionException;
import com.ovopark.dc.util.ClassUtil;
import com.ovopark.dc.util.ReflectUtil;
import com.ovopark.dc.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(ExtensionLoader.class);
    private static final ConcurrentHashMap<Class<?>, ExtensionLoader<?>> EXTENSION_LOADER_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Object> EXTENSION_INSTANCES = new ConcurrentHashMap();
    private static final String DIR = "META-INF/broker/";
    private final Class<?> type;
    private volatile Class<?> cacheAdaptiveClass = null;
    private final ConcurrentHashMap<Class<?>, String> cacheName = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Holder<Object>> cacheInstance = new ConcurrentHashMap();
    private Set<Class<?>> cachedWrappers;
    private final ExtensionFactory extensionFactory;
    private Holder<Object> cacheAdaptiveInstance = new Holder();
    private String defaultName;
    private Holder<Map<String, Class<?>>> cacheClasses = new Holder();
    private Compiler compiler;

    private ExtensionLoader(Class<?> clazz) {
        this.type = clazz;
        this.extensionFactory = clazz == ExtensionFactory.class ? null : ExtensionLoader.getExtensionLoader(ExtensionFactory.class).getAdaptive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getAdaptive() {
        try {
            Object object = this.cacheAdaptiveInstance.getObject();
            if (object == null) {
                Holder<Object> holder = this.cacheAdaptiveInstance;
                synchronized (holder) {
                    if (object == null) {
                        object = this.createAdaptive();
                        this.cacheAdaptiveInstance.setObject(object);
                    }
                }
            }
            Object data = object;
            return (T)data;
        }
        catch (Exception exception) {
            log.error("getAdaptiveInstance error", (Throwable)exception);
            throw new ExtensionException("Extension " + this.type.getName() + " getAdaptiveInstance error");
        }
    }

    public T getDefaultExtension() {
        this.getExtensionClasses();
        if (StringUtils.isEmpty((String)this.defaultName)) {
            return null;
        }
        return this.getExtension(this.defaultName);
    }

    private T createAdaptive() {
        Class<?> adaptiveClass = this.getAdaptiveClass();
        try {
            return (T)this.injectExtension(adaptiveClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private T injectExtension(T instance) {
        if (this.extensionFactory == null) {
            return instance;
        }
        for (Method method : instance.getClass().getMethods()) {
            Class<?> type;
            if (!this.isSetter(method) || ReflectUtil.isPrimitive(type = method.getParameterTypes()[0])) continue;
            try {
                String propertyName = method.getName().length() > 4 ? method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4) : "";
                Object object = this.extensionFactory.getExtension(type, propertyName);
                if (object == null) continue;
                method.invoke(instance, object);
            }
            catch (Exception exception) {
                log.error("Failed to inject extension " + type + " when load adaptive class on " + exception);
            }
        }
        return instance;
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && Modifier.isPublic(method.getModifiers());
    }

    private Class<?> getAdaptiveClass() {
        this.getExtensionClasses();
        if (this.cacheAdaptiveClass != null) {
            return this.cacheAdaptiveClass;
        }
        this.cacheAdaptiveClass = this.createAdaptiveClass();
        return this.cacheAdaptiveClass;
    }

    private Class<?> createAdaptiveClass() {
        AdaptiveGenerate generate = new AdaptiveGenerate(this.type, this.defaultName);
        String code = generate.generate();
        if (this.compiler == null) {
            this.compiler = new JavassistCompiler();
        }
        return this.compiler.compile(code, ExtensionLoader.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> getExtensionClasses() {
        Map<String, Class<?>> classMap = this.cacheClasses.getObject();
        if (classMap == null) {
            Holder<Map<String, Class<?>>> holder = this.cacheClasses;
            synchronized (holder) {
                classMap = this.cacheClasses.getObject();
                if (classMap == null) {
                    classMap = this.loadExtensionClasses();
                    this.cacheClasses.setObject(classMap);
                }
            }
        }
        return classMap;
    }

    private Map<String, Class<?>> loadExtensionClasses() {
        this.getDefaultExtensionName();
        HashMap classMap = new HashMap();
        this.loadDir(classMap, DIR, this.type.getName());
        return classMap;
    }

    private void getDefaultExtensionName() {
        Use use = this.type.getAnnotation(Use.class);
        if (use == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)use.value())) {
            this.defaultName = use.value();
        }
    }

    private void loadDir(Map<String, Class<?>> classMap, String dir, String name) {
        String fileName = dir + name;
        try {
            Enumeration<URL> urls = null;
            ClassLoader classLoader = ClassUtil.getClassLoader(ExtensionLoader.class);
            urls = classLoader == null ? ClassLoader.getSystemResources(fileName) : classLoader.getResources(fileName);
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    this.loadResource(classMap, url, classLoader);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadResource(Map<String, Class<?>> classMap, URL url, ClassLoader classLoader) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                int index = line.indexOf("#");
                if (index >= 0) {
                    line = line.substring(0, index);
                }
                if ((line = line.trim()).length() <= 0) continue;
                try {
                    String name = null;
                    int pos = line.indexOf("=");
                    if (pos > 0) {
                        name = line.substring(0, pos).trim();
                        line = line.substring(pos + 1).trim();
                    }
                    this.loadClass(classMap, url, name, Class.forName(line, true, classLoader));
                }
                catch (Exception exception) {}
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadClass(Map<String, Class<?>> classMap, URL url, String name, Class<?> aClass) {
        if (!this.type.isAssignableFrom(aClass)) {
            throw new ExtensionException(aClass.getName() + "\u4e0d\u662f\u6307\u5b9a\u5b9e\u73b0\u7c7b");
        }
        if (aClass.isAnnotationPresent(Adaptive.class)) {
            this.cacheAdaptive(aClass);
        } else if (this.isWrapper(aClass)) {
            this.cacheWrapper(aClass);
        } else {
            String[] nameList = name.split(",");
            if (nameList != null && nameList.length > 0) {
                for (String one : nameList) {
                    this.cacheName(one, aClass);
                    this.saveExtensionClass(classMap, aClass, one);
                }
            }
        }
    }

    private void cacheWrapper(Class<?> aClass) {
        if (this.cachedWrappers == null) {
            this.cachedWrappers = new HashSet();
        }
        this.cachedWrappers.add(aClass);
    }

    private boolean isWrapper(Class<?> aClass) {
        try {
            aClass.getConstructor(this.type);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void cacheAdaptive(Class<?> aClass) {
        if (this.cacheAdaptiveClass == null) {
            this.cacheAdaptiveClass = aClass;
        } else if (!this.cacheAdaptiveClass.equals(aClass)) {
            log.error("\u4e0d\u53ea\u4e00\u4e2a\u62d3\u5c55\u70b9\u51fd\u6570");
            throw new ExtensionException("\u62d3\u5c55\u70b9\u51fd\u6570\u4e0d\u53ea\u6709\u4e00\u4e2a");
        }
    }

    private void saveExtensionClass(Map<String, Class<?>> classMap, Class<?> aClass, String one) {
        Class<?> clazz = classMap.get(one);
        if (clazz != null) {
            log.error("\u91cd\u590d\u52a0\u8f7d\u7684\u7c7b");
            throw new ExtensionException("\u91cd\u590d\u52a0\u8f7d\u7c7b");
        }
        classMap.put(one, aClass);
    }

    private void cacheName(String one, Class<?> aClass) {
        if (this.cacheName.containsKey(aClass)) {
            this.cacheName.put(aClass, one);
        }
    }

    private static <T> boolean extensionAnnotation(Class<T> clazz) {
        return clazz.isAnnotationPresent(Use.class);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> clazz) {
        if (clazz == null) {
            throw new ExtensionException("\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!clazz.isInterface()) {
            throw new ExtensionException("\u4e0d\u662f\u63a5\u53e3\uff0c\u65e0\u6cd5\u52a0\u8f7d");
        }
        if (!ExtensionLoader.extensionAnnotation(clazz)) {
            throw new ExtensionException("\u65e0\u76f8\u5e94\u7684\u6ce8\u89e3");
        }
        ExtensionLoader<?> loader = EXTENSION_LOADER_MAP.get(clazz);
        if (loader == null) {
            EXTENSION_LOADER_MAP.putIfAbsent(clazz, new ExtensionLoader<T>(clazz));
            loader = EXTENSION_LOADER_MAP.get(clazz);
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String name) {
        Holder<Object> holder = this.getOrCreateHolder(name);
        Object object = holder.getObject();
        if (object == null) {
            Holder<Object> holder2 = holder;
            synchronized (holder2) {
                object = holder.getObject();
                if (object == null) {
                    object = this.createExtension(name);
                    holder.setObject(object);
                }
            }
        }
        return (T)object;
    }

    private T createExtension(String name) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw new ExtensionException("\u65e0\u6b64\u7c7b" + name);
        }
        try {
            Object instance = EXTENSION_INSTANCES.get(clazz);
            if (instance == null) {
                EXTENSION_INSTANCES.putIfAbsent(clazz, clazz.newInstance());
                instance = EXTENSION_INSTANCES.get(clazz);
            }
            this.injectExtension(instance);
            return (T)instance;
        }
        catch (Exception exception) {
            log.error("\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25");
            throw new ExtensionException("\u521b\u5efa\u5931\u8d25");
        }
    }

    private Holder<Object> getOrCreateHolder(String name) {
        Holder<Object> holder = this.cacheInstance.get(name);
        if (holder == null) {
            this.cacheInstance.putIfAbsent(name, new Holder());
            holder = this.cacheInstance.get(name);
        }
        return holder;
    }

    public Set<String> getSupportedExtensions() {
        Map<String, Class<?>> classMap = this.getExtensionClasses();
        return Collections.unmodifiableSet(new HashSet<String>(classMap.keySet()));
    }
}

