/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.loader.factory;

import com.ovopark.dc.loader.annotation.Adaptive;
import com.ovopark.dc.loader.extension.ExtensionLoader;
import com.ovopark.dc.loader.factory.ExtensionFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Adaptive
public class AdaptiveFactory
implements ExtensionFactory {
    private final List<ExtensionFactory> extensionFactoryList;

    public AdaptiveFactory() {
        ExtensionLoader<ExtensionFactory> loader = ExtensionLoader.getExtensionLoader(ExtensionFactory.class);
        ArrayList<ExtensionFactory> data = new ArrayList<ExtensionFactory>();
        for (String name : loader.getSupportedExtensions()) {
            data.add(loader.getExtension(name));
        }
        this.extensionFactoryList = Collections.unmodifiableList(data);
    }

    @Override
    public <T> T getExtension(Class<T> type, String name) {
        for (ExtensionFactory extensionFactory : this.extensionFactoryList) {
            T extension = extensionFactory.getExtension(type, name);
            if (extension == null) continue;
            return extension;
        }
        return null;
    }
}

