/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.loader.generate;

import com.ovopark.dc.loader.annotation.Adaptive;
import com.ovopark.dc.loader.extension.ExtensionLoader;
import com.ovopark.dc.storage.broker.config.UrlConfig;
import com.ovopark.dc.storage.broker.model.exception.ExtensionException;
import com.ovopark.dc.util.StringUtils;
import java.lang.reflect.Method;

public class AdaptiveGenerate {
    private final Class<?> type;
    private String defaultName;

    public AdaptiveGenerate(Class<?> type, String defaultName) {
        this.type = type;
        this.defaultName = defaultName;
    }

    private boolean isAdaptiveMethod() {
        for (Method method : this.type.getMethods()) {
            if (!method.isAnnotationPresent(Adaptive.class)) continue;
            return true;
        }
        return false;
    }

    public String generate() {
        if (!this.isAdaptiveMethod()) {
            throw new ExtensionException("\u65e0\u81ea\u9002\u5e94\u65b9\u6cd5\uff0c\u65e0\u6cd5\u751f\u6210");
        }
        StringBuilder code = new StringBuilder();
        code.append(this.generatePackage());
        code.append(this.generateImport());
        code.append(this.generateClass());
        for (Method method : this.type.getMethods()) {
            code.append(this.generateMethod(method));
        }
        code.append("}");
        return code.toString();
    }

    private String generateMethod(Method method) {
        String returnType = method.getReturnType().getCanonicalName();
        String methodName = method.getName();
        String methodContent = this.generateContent(method);
        String methodArgs = this.generateArgs(method);
        String methodException = this.generateException(method);
        return String.format("public %s %s(%s) %s {\n%s}\n", returnType, methodName, methodArgs, methodException, methodContent);
    }

    private String generateContent(Method method) {
        Adaptive adaptive = method.getAnnotation(Adaptive.class);
        if (adaptive == null) {
            return this.generateUnsupported(method);
        }
        StringBuilder code = new StringBuilder();
        int urlConfigIndex = this.getParamIndex(method);
        if (urlConfigIndex != -1) {
            code.append(this.generateCheck(urlConfigIndex));
        }
        String value = this.getAdaptiveName(adaptive);
        code.append(this.generateParam(value));
        code.append(this.generateParamNull(value));
        code.append(this.generateExtensionAssignment());
        code.append(this.generateReturn(method));
        return code.toString();
    }

    private String generateReturn(Method method) {
        String returnStatement = method.getReturnType().equals(Void.TYPE) ? "" : "return ";
        Class<?>[] params = method.getParameterTypes();
        StringBuilder code = new StringBuilder();
        if (params.length > 0) {
            for (int index = 0; index < params.length; ++index) {
                code.append("arg").append(index);
                if (index >= params.length - 1) continue;
                code.append(",");
            }
        }
        return returnStatement + String.format("extension.%s(%s);", method.getName(), code.toString());
    }

    private String generateExtensionAssignment() {
        return String.format("%s extension = ExtensionLoader.getExtensionLoader(%s.class).getExtension(extName);\n", this.type.getName(), this.type.getName());
    }

    private String generateParamNull(String value) {
        return String.format("if(extName == null){ throw new UnsupportedOperationException(\"failed to get extension %s \"); }\n", this.type.getSimpleName());
    }

    private String getAdaptiveName(Adaptive adaptive) {
        String value = adaptive.value();
        if (StringUtils.isEmpty((String)value) && StringUtils.isEmpty((String)this.defaultName)) {
            value = this.type.getSimpleName().toLowerCase();
        }
        return value;
    }

    private String generateParam(String value) {
        String paramsName = null;
        if (StringUtils.isNotEmpty((String)value)) {
            paramsName = String.format("String extName = config.getParamInfo(\"%s\");", value);
        } else if (StringUtils.isNotEmpty((String)this.defaultName)) {
            paramsName = String.format("String extName = \"%s\";", this.defaultName);
        }
        return paramsName;
    }

    private String generateCheck(int urlConfigIndex) {
        return String.format("if(arg%s == null){ throw new UnsupportedOperationException(\"urlConfig is null \"); }; %s config = arg%d;", urlConfigIndex, UrlConfig.class.getName(), urlConfigIndex);
    }

    private String generateNull(Method method) {
        return String.format("throw new UnsupportedOperationException(\"method %s param not urlConfig !\");\n", method.getName());
    }

    private int getParamIndex(Method method) {
        Class<?>[] params = method.getParameterTypes();
        for (int index = 0; index < params.length; ++index) {
            if (!params[index].equals(UrlConfig.class)) continue;
            return index;
        }
        return -1;
    }

    private String generateUnsupported(Method method) {
        return String.format("throw new UnsupportedOperationException(\"method %s not adaptive method !\");\n", method.getName());
    }

    private String generateException(Method method) {
        Class<?>[] exceptions = method.getExceptionTypes();
        StringBuilder code = new StringBuilder();
        if (exceptions.length > 0) {
            for (Class<?> exception : exceptions) {
                code.append(exception.getCanonicalName()).append(",");
            }
            return code.toString().substring(0, code.length() - 1);
        }
        return "";
    }

    private String generateArgs(Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params.length > 0) {
            StringBuilder code = new StringBuilder();
            for (int index = 0; index < params.length; ++index) {
                code.append(params[index].getCanonicalName()).append(" arg").append(index).append(",");
            }
            return code.toString().substring(0, code.length() - 1);
        }
        return "";
    }

    private String generateClass() {
        return String.format("public class %s$Adaptive implements %s { \n", this.type.getSimpleName(), this.type.getCanonicalName());
    }

    private String generateImport() {
        return String.format("import %s;\n", ExtensionLoader.class.getName());
    }

    private String generatePackage() {
        return String.format("package %s;\n", this.type.getPackage().getName());
    }
}

