/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc;

import com.ovopark.boot.core.aop.EdasSignAop;
import com.ovopark.boot.core.aop.RouteAop;
import com.ovopark.dc.storage.broker.utils.SpringContextUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.ConfigurableEnvironment;

@ServletComponentScan
@ComponentScan(basePackages={"com.ovopark.dc.config", "com.ovopark.dc.storage.broker"}, basePackageClasses={RouteAop.class, EdasSignAop.class})
@SpringBootApplication
public class BrokerApp {
    private static final Logger log = LoggerFactory.getLogger(BrokerApp.class);
    protected static final Logger logger = LoggerFactory.getLogger(BrokerApp.class);

    public static void main(String[] args) throws UnknownHostException, InterruptedException, ExecutionException, TimeoutException {
        SpringApplication app = new SpringApplication(new Class[]{BrokerApp.class});
        ConfigurableApplicationContext run = SpringApplication.run(BrokerApp.class, (String[])args);
        SpringContextUtil.setApplicationContext((ApplicationContext)run);
        ConfigurableEnvironment env = run.getEnvironment();
        String protocol = "http";
        if (env.getProperty("server.ssl.key-store") != null) {
            protocol = "https";
        }
        log.info("\n----------------------------------------------------------------\n\tOvopark DC Rule Push Application '{}' is running! Access URLs:\n\tLocal: \t\t{}://localhost:{}\n\tExternal: \t{}://{}:{}\n\tProfile(s): \t{}\n\t{} Ovopark DC Rule Push  Started\uff01\uff01\n----------------------------------------------------------------", new Object[]{env.getProperty("spring.application.name"), protocol, env.getProperty("server.port"), protocol, InetAddress.getLocalHost().getHostAddress(), env.getProperty("server.port"), env.getActiveProfiles(), LocalDateTime.now()});
        logger.info("BrokerApp is success!");
    }
}

