/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.config;

import com.ovopark.boot.common.code.AbstractReturnCode;
import com.ovopark.boot.common.code.ApiReturnCode;
import com.ovopark.boot.common.code.support.ApiCodeResult;
import com.ovopark.boot.kit.lang.DigitKit;
import com.ovopark.dc.storage.broker.code.StorageApiReturnCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringJoiner;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingRequestHeaderException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentConversionNotSupportedException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Value(value="${systemid}")
    private int systemid;
    static int index = 3;

    @ExceptionHandler(value={Exception.class})
    public Object handleBadRequest(Exception e) {
        MethodArgumentNotValidException e1;
        BindingResult bindingResult;
        logger.warn("---- wellcome terminal ----");
        logger.error(e.getMessage(), (Throwable)e);
        if (e instanceof RuntimeException && e.getMessage().contains("The specified key does not exist")) {
            return ApiCodeResult.error((AbstractReturnCode)ApiReturnCode.PARAMETER_VALIDATE_ERROR, (Object)"The file does not exist!");
        }
        if (e instanceof BindException && null != (bindingResult = ((BindException)e).getBindingResult()) && bindingResult.hasErrors()) {
            ArrayList jsonList = new ArrayList();
            bindingResult.getFieldErrors().stream().forEach(fieldError -> {
                HashMap<String, String> jsonObject = new HashMap<String, String>(2);
                jsonObject.put("field", fieldError.getField());
                jsonObject.put("warning", fieldError.getDefaultMessage());
                jsonList.add(jsonObject);
            });
            AbstractReturnCode Abcode = ApiReturnCode.PARAMETER_VALIDATE_ERROR;
            int code = DigitKit.join2Int((Object[])new Object[]{this.systemid, DigitKit.subAfer2Str((Object)Abcode.getCode(), (int)index)});
            Abcode.setCode(code);
            logger.debug("Rest request error, {}", (Object)e.getMessage());
            return ApiCodeResult.error((AbstractReturnCode)Abcode, jsonList);
        }
        if (e instanceof MissingServletRequestParameterException) {
            AbstractReturnCode Abcode = null;
            Abcode = ((MissingServletRequestParameterException)e).getParameterType().equals("CommonsMultipartFile") ? StorageApiReturnCode.FILE_NOT_NULL : ApiReturnCode.PARAMETER_VALIDATE_ERROR;
            int code = DigitKit.join2Int((Object[])new Object[]{this.systemid, DigitKit.subAfer2Str((Object)Abcode.getCode(), (int)index)});
            Abcode.setCode(code);
            ArrayList jsonList = new ArrayList();
            HashMap<String, String> jsonObject = new HashMap<String, String>(2);
            jsonObject.put("field", ((MissingServletRequestParameterException)e).getParameterName());
            jsonObject.put("warning", e.getMessage());
            jsonList.add(jsonObject);
            logger.debug("Rest request error, {}", (Object)e.getMessage());
            return ApiCodeResult.error((AbstractReturnCode)Abcode, jsonList);
        }
        if (e instanceof MethodArgumentNotValidException) {
            e1 = (MethodArgumentNotValidException)e;
            StringJoiner sj = new StringJoiner(";");
            e1.getBindingResult().getFieldErrors().forEach(x -> sj.add(x.getDefaultMessage()));
            String err = sj.toString();
            return ApiCodeResult.error((AbstractReturnCode)ApiReturnCode.PARAMETER_VALIDATE_ERROR, (Object)err);
        }
        if (e instanceof ConstraintViolationException) {
            e1 = (ConstraintViolationException)e;
            StringJoiner sj = new StringJoiner(";");
            e1.getConstraintViolations().forEach(x -> sj.add(x.getMessage()));
            return ApiCodeResult.error((AbstractReturnCode)ApiReturnCode.PARAMETER_VALIDATE_ERROR, (Object)sj.toString());
        }
        if (e instanceof MethodArgumentConversionNotSupportedException) {
            e1 = (MethodArgumentConversionNotSupportedException)e;
            String parameterName = e1.getParameter().getParameterName();
            return ApiCodeResult.error((AbstractReturnCode)ApiReturnCode.PARAMETER_VALIDATE_ERROR, (Object)(parameterName + "\u7684\u503c\u4e0d\u5408\u6cd5!"));
        }
        if (e instanceof MethodArgumentTypeMismatchException) {
            e1 = (MethodArgumentTypeMismatchException)e;
            String name1 = e1.getParameter().getParameterType().getName();
            String parameterName = e1.getParameter().getParameterName();
            return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.PARAM_TYPE_ERR, (Object)(parameterName + "\u9700\u8981\u4f20\u9012\u7c7b\u578b->" + name1));
        }
        if (e instanceof MissingServletRequestPartException) {
            e1 = (MissingServletRequestPartException)e;
            String requestPartName = e1.getRequestPartName();
            return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.NO_PARAM, (Object)("\u4f20\u9012\u7684" + requestPartName + "\u7684\u7c7b\u578b\u6b63\u786e\uff1f\uff1f"));
        }
        if (e instanceof MultipartException) {
            return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.NOT_MULTIPART_REQUEST, (Object)"\u8868\u5355\u53c2\u6570 file \u5fc5\u4f20\uff01");
        }
        if (e instanceof MissingRequestHeaderException) {
            MissingRequestHeaderException exception = (MissingRequestHeaderException)e;
            return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.NO_PARAM, (Object)exception.getMessage());
        }
        if (e instanceof HttpRequestMethodNotSupportedException) {
            return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.REQUEST_METHOD_ERR, (Object)e.getMessage());
        }
        logger.error("Error: handleBadRequest StackTrace : {}", (Throwable)e);
        return ApiCodeResult.error((AbstractReturnCode)ApiReturnCode.API_SYSTEM_ERROR);
    }
}

