/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.storage.broker.agent;

import com.google.common.collect.Maps;
import com.ovopark.dc.storage.broker.annotation.StorageTypeAnnotation;
import com.ovopark.dc.storage.broker.service.BaseService;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;

@Service
public class StStrategyAgent {
    @Autowired
    private ApplicationContext applicationContext;
    private static final Map<String, BaseService> strategy_cache_map = Maps.newConcurrentMap();

    @PostConstruct
    private void init() {
        strategy_cache_map.putAll(this.applicationContext.getBeansOfType(BaseService.class));
    }

    public BaseService getStrategy(Integer type) {
        Optional<BaseService> strategy = strategy_cache_map.values().stream().map(baseService -> {
            StorageTypeAnnotation stAnnotation = (StorageTypeAnnotation)AnnotationUtils.findAnnotation(baseService.getClass(), StorageTypeAnnotation.class);
            if (Objects.equals(stAnnotation.type(), type)) {
                return baseService;
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
        if (strategy.isPresent()) {
            return strategy.get();
        }
        throw new RuntimeException("\u7b56\u7565\u83b7\u5f97\u5931\u8d25");
    }
}

