/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.storage.broker.controller;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.ovopark.boot.common.code.AbstractReturnCode;
import com.ovopark.boot.common.code.support.ApiCodeResult;
import com.ovopark.boot.common.plugin.activerecord.GG;
import com.ovopark.boot.core.controller.CoCoController;
import com.ovopark.boot.utils.lang.ConvertUtils;
import com.ovopark.dc.storage.broker.agent.StStrategyAgent;
import com.ovopark.dc.storage.broker.code.StorageApiReturnCode;
import com.ovopark.dc.storage.broker.common.em.AwsBucketEnum;
import com.ovopark.dc.storage.broker.common.em.ModuleEnum;
import com.ovopark.dc.storage.broker.common.em.StorageTypeEnum;
import com.ovopark.dc.storage.broker.common.util.JwtUtils;
import com.ovopark.dc.storage.broker.common.util.VerifyBO;
import com.ovopark.dc.storage.broker.entity.CustResult;
import com.ovopark.dc.storage.broker.utils.AliyunHelper;
import com.ovopark.dc.storage.broker.utils.AwsS3Helper;
import com.ovopark.dc.storage.broker.utils.CtyunHelper;
import com.ovopark.dc.storage.broker.utils.MinioHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Validated
@RestController
@RequestMapping(value={"/api/dc/storage/oss"})
public class OssController
extends CoCoController {
    protected static final Logger logger = LoggerFactory.getLogger(OssController.class);
    @Autowired
    private StStrategyAgent agent;
    @Value(value="${callback.yuanqu}")
    private String callback_yuanqu;
    private static String DEVICE = "device";

    @PostMapping(value={"/upload/new"})
    public GG<Map<String, Object>> uploadNew(@RequestParam(value="file", required=false) MultipartFile file, @RequestParam(value="pic", required=false) MultipartFile pic, @RequestParam(name="platform", defaultValue="soft") String platform, @RequestParam(name="storageType", defaultValue="aliyun") String storageType, @RequestParam(name="moduleId", defaultValue="1") Integer moduleId, @RequestParam(name="isDate", defaultValue="true") Boolean isDate, @RequestParam(name="callback", required=false) String callback, @RequestParam(name="customFilePath", required=false) String customFilePath, @RequestParam(name="customFileName", required=false) String customFileName) {
        return this.upload(file, pic, platform, storageType, moduleId, isDate, callback, customFilePath, customFileName);
    }

    @PostMapping(value={"/upload"})
    public GG<Map<String, Object>> upload(@RequestParam(value="file", required=false) MultipartFile file, @RequestParam(value="pic", required=false) MultipartFile pic, @RequestParam(name="platform", defaultValue="soft") String platform, @RequestParam(name="storageType", defaultValue="aliyun") String storageType, @RequestParam(name="moduleId", defaultValue="1") Integer moduleId, @RequestParam(name="isDate", defaultValue="true") Boolean isDate, @RequestParam(name="callback", required=false) String callback, @RequestParam(name="customFilePath", required=false) String customFilePath, @RequestParam(name="customFileName", required=false) String customFileName) {
        String s;
        int i;
        logger.info("callback --> {}", (Object)callback);
        boolean isSendCallBack = false;
        boolean isDevice = false;
        String picName = "";
        String fileName = "";
        String[] limitArray = null;
        if (!StringUtils.isEmpty((Object)customFilePath) && (i = customFilePath.indexOf("/")) == 0) {
            return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.PARAM_ERROR, (Object)"customFilePath invalid \uff01the first character can not be '/'");
        }
        if (!StringUtils.isEmpty((Object)customFileName) && !StringUtils.isEmpty((Object)(s = FileNameUtil.extName((String)customFileName)))) {
            return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.PARAM_ERROR, (Object)"customFileName invalid \uff01The name cannot contain the suffix '.'");
        }
        if (platform.equals(DEVICE)) {
            if (pic == null) {
                return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.NO_PARAM, (Object)"pic file do not empty \uff01");
            }
            picName = pic.getOriginalFilename();
            i = picName.lastIndexOf(".");
            String substring = "";
            if (i > 0) {
                substring = picName.substring(0, i);
            }
            limitArray = substring.split("_");
        } else {
            if (file == null) {
                return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.NO_PARAM, (Object)"file do not empty \uff01");
            }
            fileName = file.getOriginalFilename();
        }
        GG gg = this.paramCheck(platform, fileName, picName, callback);
        JSONObject callBack = null;
        if (gg.isIsError()) {
            return gg;
        }
        try {
            callBack = !StringUtils.isEmpty((Object)gg.getData()) ? (JSONObject)gg.getData() : null;
        }
        catch (Exception e) {
            logger.error("Exception : {} getData : {}", (Object)e.getMessage(), gg.getData());
            callBack = null;
        }
        Integer i_storageType = null;
        Integer i_moduleId = null;
        Boolean i_isDate = null;
        switch (platform) {
            case "device": {
                i_storageType = ConvertUtils.toInt((Object)StorageTypeEnum.getValue((String)storageType), (Integer)StorageTypeEnum.aliyun.getValue());
                i_moduleId = moduleId;
                i_isDate = isDate;
                isDevice = true;
                isSendCallBack = true;
                break;
            }
            default: {
                HttpServletRequest request = this.getHttpServletRequest();
                i_storageType = ConvertUtils.toInt((Object)StorageTypeEnum.getValue((String)request.getHeader("storageType")), (Integer)StorageTypeEnum.aliyun.getValue());
                i_moduleId = i_storageType == 5 ? ConvertUtils.toInt((Object)request.getHeader("moduleId"), (Integer)AwsBucketEnum.OVOPARK.getModuleId()) : ConvertUtils.toInt((Object)request.getHeader("moduleId"), (Integer)ModuleEnum.OVOPARK.getModuleId());
                i_isDate = ConvertUtils.toBoolean((Object)request.getHeader("isDate"), (Boolean)true);
            }
        }
        if (StringUtils.isEmpty((Object)ModuleEnum.getModuleName((int)i_moduleId))) {
            return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.PARAM_ERROR, (Object)"moduleId not found !");
        }
        CustResult ossUrl = null;
        try {
            long start = System.currentTimeMillis();
            if (platform.equals(DEVICE)) {
                ossUrl = this.agent.getStrategy(i_storageType).upload(i_moduleId, picName, pic.getInputStream(), i_isDate, customFilePath, customFileName);
                if (!ossUrl.getIsFail().booleanValue()) {
                    return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.FILE_UPLOAD_ERROR, (Object)"\u7f51\u7edc\u7e41\u5fd9\uff0c\u8054\u7cfb\u7ba1\u7406\u5458 XiuEr!");
                }
            } else {
                ossUrl = this.agent.getStrategy(i_storageType).upload(i_moduleId, fileName, file.getInputStream(), i_isDate, customFilePath, customFileName);
                if (ossUrl.getIsFail().booleanValue()) {
                    return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.FILE_UPLOAD_ERROR, (Object)ossUrl.getMsg());
                }
            }
            long end = System.currentTimeMillis() - start;
            System.out.println("\u4e0a\u4f20\u8017\u65f6 = " + end + "\u6beb\u79d2");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GG callbackResult = this.sendToCallback(isSendCallBack, callBack, limitArray, ossUrl, callback);
        if (callbackResult != null) {
            return callbackResult;
        }
        if (isDevice) {
            return ApiCodeResult.success((AbstractReturnCode)StorageApiReturnCode.MY_SUCCESS, (Object)ossUrl);
        }
        return ApiCodeResult.success(ossUrl);
    }

    public GG sendToCallback(boolean isSendCallBack, JSONObject callBack, String[] s, CustResult ossUrl, String callback) {
        String body = null;
        try {
            if (isSendCallBack) {
                if (!StringUtils.isEmpty((Object)callBack)) {
                    HttpRequest post = HttpUtil.createPost((String)this.callback_yuanqu);
                    String s1 = callBack.toJSONString();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String deviceMac = JsonPath.read((String)s1, (String)"$.body.mac", (Predicate[])new Predicate[0]).toString();
                    map.put("deviceMac", deviceMac);
                    map.put("deviceId", JsonPath.read((String)s1, (String)"$.body.deviceId", (Predicate[])new Predicate[0]));
                    if (s.length > 0) {
                        try {
                            String s2 = s[s.length - 1];
                            Integer integer = new Integer(s2);
                            map.put("presetNo", integer);
                        }
                        catch (Exception e) {
                            map.put("presetNo", null);
                        }
                    } else {
                        map.put("presetNo", null);
                    }
                    map.put("picUrl", ossUrl.getAccessUrl());
                    post.body(JSON.toJSONString(map));
                    body = post.execute().body();
                    logger.info("\u53d1\u7ed9\u827e\u4f1f\u9752\u7684\u63a5\u53e3\u4fe1\u606f request : {} response : {}", map, (Object)body);
                } else {
                    logger.error("\u5e73\u53f0\u4e3a platfrom \u65f6 callBack \u4e0d\u80fd\u4e3a\u7a7a!");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u7ed9\u827e\u603b\u7684\u63a5\u53e3\u62a5\u9519 e.getMessage {} callback \u6570\u636e\u6709\u8bef {}", (Object)e.getMessage(), (Object)callBack);
            return ApiCodeResult.success((AbstractReturnCode)StorageApiReturnCode.MY_SUCCESS, (Object)("callback\u6570\u636e\u6709\u8bef : " + callback));
        }
        return null;
    }

    public GG paramCheck(String platform, String fileName, String picName, String callback) {
        logger.info("file name :{}", (Object)fileName);
        logger.info("pic name :{}", (Object)picName);
        if (platform.equals(DEVICE)) {
            if (picName == null || StringUtils.isEmpty((Object)picName)) {
                return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.NO_PARAM, (Object)"pic file do not empty \uff01");
            }
            if (!StringUtils.isEmpty((Object)callback)) {
                try {
                    long start = System.currentTimeMillis();
                    callback = Base64.decodeStr((CharSequence)callback);
                    long end = System.currentTimeMillis();
                    System.out.println(callback);
                    logger.info("\u8017\u65f6--- {} ms", (Object)(end - start));
                    JSONObject jsonObject = JSON.parseObject((String)callback);
                    return ApiCodeResult.success((Object)jsonObject);
                }
                catch (Exception e) {
                    logger.warn(e.getMessage());
                    try {
                        JSONArray objects = JSON.parseArray((String)callback);
                        return ApiCodeResult.success((Object)objects);
                    }
                    catch (Exception e1) {
                        logger.warn(e.getMessage());
                        return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.PARAM_TYPE_ERR, (Object)"callback \u975e\u6b63\u786ejson\u683c\u5f0f!");
                    }
                }
            }
            return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.PARAM_TYPE_ERR, (Object)"\u7ed9\u827e\u4f1f\u9752\u7684\u63a5\u53e3 callback \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return ApiCodeResult.success();
    }

    public boolean check(CustResult custResult) {
        return StringUtils.isEmpty((Object)custResult.getAccessUrl());
    }

    @RequestMapping(value={"/getOssConfig"})
    public GG<Map<String, Object>> getOssConfig() {
        HttpServletRequest request = this.getHttpServletRequest();
        Integer storageType = ConvertUtils.toInt((Object)StorageTypeEnum.getValue((String)request.getHeader("storageType")), (Integer)StorageTypeEnum.aliyun.getValue());
        return ApiCodeResult.success((Object)this.agent.getStrategy(storageType).getOssConfig());
    }

    @RequestMapping(value={"/delete"})
    public GG<?> delete(@Valid @RequestParam(value="filePath") @NotNull(message="filePath\u4e0d\u80fd\u4e3a\u7a7a") @Valid @NotNull(message="filePath\u4e0d\u80fd\u4e3a\u7a7a") String filePath) {
        HttpServletRequest request = this.getHttpServletRequest();
        Integer storageType = ConvertUtils.toInt((Object)StorageTypeEnum.getValue((String)request.getHeader("storageType")), (Integer)StorageTypeEnum.aliyun.getValue());
        Integer code = this.agent.getStrategy(storageType).delete(filePath);
        if (code == 401104) {
            return ApiCodeResult.error((AbstractReturnCode)StorageApiReturnCode.DELETE_PERMISSION_DENIED);
        }
        return ApiCodeResult.success();
    }

    @RequestMapping(value={"/getExpiredUrl"})
    public GG<?> getExpiredUrl(@RequestParam(name="storageType", required=true) @NotNull(message="storageType \u4e0d\u80fd\u4e3a\u7a7a!") @NotNull(message="storageType \u4e0d\u80fd\u4e3a\u7a7a!") String storageType, @RequestParam(name="moduleId", required=true) Integer moduleId, @RequestParam(name="path", required=true) String path, @RequestParam(name="duration", required=true) int duration, @RequestParam(name="timeUnitId", required=true, defaultValue="2") int timeUnitId, @RequestParam(name="isInternal", required=false, defaultValue="false") boolean isInternal) {
        Integer storageTypeId = ConvertUtils.toInt((Object)StorageTypeEnum.getValue((String)storageType), (Integer)StorageTypeEnum.aliyun.getValue());
        String url = this.agent.getStrategy(storageTypeId).getExpiredTime(moduleId, path, duration, timeUnitId, isInternal);
        return ApiCodeResult.success((Object)url);
    }

    @RequestMapping(value={"/getFile"})
    public void getFile(@RequestParam String token, HttpServletResponse resp) throws IOException {
        VerifyBO verifyBO = JwtUtils.verifyToken((String)token);
        if (verifyBO.getCode() == 0) {
            Map body = JwtUtils.parseToken((String)token);
            this.doDownload(body, resp);
        } else if (verifyBO.getCode() == 1) {
            logger.error("token: {} \u89e3\u6790\u7ed3\u679c\u72b6\u6001: {} ", (Object)token, (Object)verifyBO.getMsg());
            String err = verifyBO.getMsg();
            ServletOutputStream out = resp.getOutputStream();
            out.write(err.getBytes(StandardCharsets.UTF_8));
            out.flush();
            out.close();
        } else {
            logger.error("token: {} \u89e3\u6790\u7ed3\u679c\u72b6\u6001: {} ", (Object)token, (Object)verifyBO.getMsg());
            String err = "Token is not valid ! msg: " + verifyBO.getMsg();
            ServletOutputStream out = resp.getOutputStream();
            out.write(err.getBytes(StandardCharsets.UTF_8));
            out.flush();
            out.close();
        }
    }

    private void doDownload(Map<String, Object> body, HttpServletResponse resp) throws IOException {
        Object oldAccessUrl = body.get("oldAccessUrl");
        if (!StringUtils.isEmpty((Object)oldAccessUrl)) {
            logger.info("\u4e0b\u8f7d\u8001\u94fe\u63a5\u6587\u4ef6");
            HttpRequest request = HttpUtil.createRequest((Method)Method.GET, (String)oldAccessUrl.toString());
            HttpResponse execute = request.execute();
            InputStream inputStream = execute.bodyStream();
            ServletOutputStream out = resp.getOutputStream();
            out.write(IoUtil.readBytes((InputStream)inputStream));
            out.flush();
            out.close();
        } else {
            logger.info("\u4e0b\u8f7d\u65b0\u94fe\u63a5\u6587\u4ef6");
            String storageType = body.get("storageType").toString();
            Integer moduleId = new Integer(body.get("moduleId").toString());
            String path = body.get("path").toString();
            InputStream inputStream = null;
            switch (storageType) {
                case "aliyun": {
                    inputStream = AliyunHelper.downLoadFile(path);
                    break;
                }
                case "ctyun": {
                    inputStream = CtyunHelper.downloadFile(path);
                    break;
                }
                case "minio": {
                    inputStream = MinioHelper.downloadFile(ModuleEnum.getModuleName((int)moduleId), path);
                    break;
                }
                case "aws": {
                    inputStream = AwsS3Helper.downloadFile(ModuleEnum.getModuleName((int)moduleId), path);
                    break;
                }
                default: {
                    logger.error("\u4e0d\u8ba4\u8bc6\u7684storageType: {}", (Object)storageType);
                }
            }
            ServletOutputStream out = resp.getOutputStream();
            out.write(IoUtil.readBytes((InputStream)inputStream));
            out.flush();
            out.close();
        }
    }
}

