/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.storage.broker.service.impl;

import com.google.common.base.Joiner;
import com.ovopark.dc.storage.broker.annotation.StorageTypeAnnotation;
import com.ovopark.dc.storage.broker.common.em.ExpiredTimeUnit;
import com.ovopark.dc.storage.broker.common.em.ModuleEnum;
import com.ovopark.dc.storage.broker.common.em.StorageTypeEnum;
import com.ovopark.dc.storage.broker.entity.CustResult;
import com.ovopark.dc.storage.broker.prefix.AliyunPrefix;
import com.ovopark.dc.storage.broker.service.BaseService;
import com.ovopark.dc.storage.broker.utils.AliyunHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@StorageTypeAnnotation(type=1)
@Service
public class AliyunServiceImpl
implements BaseService {
    @Autowired
    private AliyunPrefix config;

    public CustResult upload(Integer moduleId, String fileName, InputStream in, Boolean isDate, String customFilePath, String customFileName) {
        String url = AliyunHelper.uploadFile(in, fileName, moduleId, customFilePath, customFileName);
        if (StringUtils.isEmpty((Object)url)) {
            CustResult custResult = new CustResult();
            custResult.setIsFail(Boolean.valueOf(true));
            custResult.setMsg("\u4e0a\u4f20\u9519\u8bef\uff01\u8054\u7cfb\u7ba1\u7406\u5458call: 13813641925");
            return custResult;
        }
        String accessUrl = Joiner.on((String)"").join((Object)this.config.getMaster().getAccessUrl(), (Object)"/", new Object[]{url});
        CustResult custResult = new CustResult();
        custResult.setModuleId(moduleId);
        custResult.setPath(url);
        custResult.setAccessUrl(accessUrl);
        custResult.setOssUrl(accessUrl);
        custResult.setStorageType(StorageTypeEnum.aliyun.getKey());
        return custResult;
    }

    public ArrayList<Object> getOssConfig() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ModuleEnum e : ModuleEnum.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("bucket", e.getModuleName());
            map.put("moduleId", e.getModuleId());
            map.put("gatewayUrl", AliyunHelper.accessUrl);
            list.add(map);
        }
        return list;
    }

    public Integer delete(String filePath) {
        return AliyunHelper.deleteFile(filePath);
    }

    public String getExpiredTime(Integer moduleId, String path, int duration, int timeUnitId, boolean isInternal) {
        ExpiredTimeUnit timeName = ExpiredTimeUnit.getTimeName((int)timeUnitId);
        GregorianCalendar calendar = new GregorianCalendar();
        switch (timeName) {
            case MILLISECONDS: {
                calendar.add(14, duration);
                break;
            }
            case SECONDS: {
                calendar.add(13, duration);
                break;
            }
            case MINUTES: {
                calendar.add(12, duration);
                break;
            }
            case HOURS: {
                calendar.add(10, duration);
                break;
            }
            case DAYS: {
                calendar.add(5, duration);
                break;
            }
            default: {
                calendar.add(13, duration);
            }
        }
        Date time = calendar.getTime();
        String expiredUrl = AliyunHelper.getExpiredUrl(path, time, isInternal);
        return expiredUrl;
    }
}

