/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.storage.broker.service.impl;

import com.ovopark.dc.storage.broker.annotation.StorageTypeAnnotation;
import com.ovopark.dc.storage.broker.common.em.AwsBucketEnum;
import com.ovopark.dc.storage.broker.common.em.ExpiredTimeUnit;
import com.ovopark.dc.storage.broker.common.em.ModuleEnum;
import com.ovopark.dc.storage.broker.common.em.StorageTypeEnum;
import com.ovopark.dc.storage.broker.entity.CustResult;
import com.ovopark.dc.storage.broker.service.BaseService;
import com.ovopark.dc.storage.broker.utils.AwsS3Helper;
import io.minio.BucketExistsArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MinioClient;
import io.minio.http.Method;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@StorageTypeAnnotation(type=5)
@Service
public class AwsS3ServiceImpl
implements BaseService {
    private static final Logger log = LoggerFactory.getLogger(AwsS3ServiceImpl.class);
    @Autowired
    AwsS3Helper awsS3Helper;

    public CustResult upload(Integer moduleId, String fileName, InputStream in, Boolean isDate, String customFilePath, String customFileName) {
        if (StringUtils.isEmpty((Object)AwsBucketEnum.getModuleName((int)moduleId))) {
            CustResult result = new CustResult();
            result.setIsFail(Boolean.valueOf(true));
            result.setMsg("\u6876\u4e0d\u5b58\u5728!");
            return result;
        }
        MinioClient minioer = AwsS3Helper.getMinioClient();
        try {
            boolean b = minioer.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(AwsBucketEnum.getModuleName((int)moduleId))).build());
            if (!b) {
                CustResult result = new CustResult();
                result.setIsFail(Boolean.valueOf(true));
                result.setMsg("\u6876\u4e0d\u5b58\u5728!");
                return result;
            }
        }
        catch (Exception e) {
            log.error("AWS bucketExists: {}", (Object)e.getMessage());
        }
        String key = AwsS3Helper.putObjectToAwsS3(minioer, moduleId, fileName, in, isDate, customFilePath, customFileName);
        if (!StringUtils.isEmpty((Object)key)) {
            String accessurl = AwsS3Helper.accessUrl + "/" + AwsBucketEnum.getModuleName((int)moduleId) + "/" + key;
            CustResult result = new CustResult();
            result.setAccessUrl(accessurl);
            result.setOssUrl(accessurl);
            result.setPath(key);
            result.setModuleId(moduleId);
            result.setStorageType(StorageTypeEnum.aws.getKey());
            return result;
        }
        return null;
    }

    public Object getOssConfig() {
        ArrayList list = new ArrayList();
        for (AwsBucketEnum e : AwsBucketEnum.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("bucket", e.getModuleName());
            map.put("moduleId", e.getModuleId());
            map.put("gatewayUrl", AwsS3Helper.getOssEndPoint());
            list.add(map);
        }
        return list;
    }

    public Integer delete(String url) {
        return null;
    }

    public String getExpiredTime(Integer moduleId, String path, int duration, int timeUnitId, boolean isInternal) {
        TimeUnit timeUnit;
        MinioClient minioClient = !isInternal ? AwsS3Helper.getDeiniteMinioClient() : AwsS3Helper.getDeiniteMinioClientInternal();
        String bucketName = ModuleEnum.getModuleName((int)moduleId);
        ExpiredTimeUnit moduleName = ExpiredTimeUnit.getTimeName((int)timeUnitId);
        switch (moduleName) {
            case MILLISECONDS: {
                timeUnit = TimeUnit.MILLISECONDS;
                break;
            }
            case SECONDS: {
                timeUnit = TimeUnit.SECONDS;
                break;
            }
            case MINUTES: {
                timeUnit = TimeUnit.MINUTES;
                break;
            }
            case HOURS: {
                timeUnit = TimeUnit.HOURS;
                break;
            }
            case DAYS: {
                timeUnit = TimeUnit.DAYS;
                break;
            }
            default: {
                timeUnit = TimeUnit.SECONDS;
            }
        }
        String url = null;
        try {
            url = minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(path)).expiry(duration, timeUnit).build());
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return url;
    }
}

