/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.storage.broker.service.impl;

import com.amazonaws.services.s3.AmazonS3;
import com.google.common.base.Joiner;
import com.ovopark.dc.storage.broker.annotation.StorageTypeAnnotation;
import com.ovopark.dc.storage.broker.common.em.ExpiredTimeUnit;
import com.ovopark.dc.storage.broker.common.em.ModuleEnum;
import com.ovopark.dc.storage.broker.common.em.StorageTypeEnum;
import com.ovopark.dc.storage.broker.entity.CustResult;
import com.ovopark.dc.storage.broker.service.BaseService;
import com.ovopark.dc.storage.broker.utils.CtyunHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@StorageTypeAnnotation(type=3)
@Service
public class CtyunServiceImpl
implements BaseService {
    public CustResult upload(Integer moduleId, String fileName, InputStream in, Boolean isDate, String customFilePath, String customFileName) {
        AmazonS3 oosClient = CtyunHelper.getAmazonS3();
        String key = CtyunHelper.putObject(oosClient, moduleId, fileName, in, customFilePath, customFileName);
        String accessUrl = Joiner.on((String)"").join((Object)"http://", (Object)CtyunHelper.getOosBucketName(), new Object[]{".", CtyunHelper.getAccessUrl(), "/", key});
        CustResult custResult = new CustResult();
        custResult.setAccessUrl(accessUrl);
        custResult.setOssUrl(accessUrl);
        custResult.setStorageType(StorageTypeEnum.ctyun.getKey());
        custResult.setModuleId(moduleId);
        custResult.setPath(key);
        return custResult;
    }

    public ArrayList<Object> getOssConfig() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ModuleEnum e : ModuleEnum.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("bucket", e.getModuleName());
            map.put("moduleId", e.getModuleId());
            map.put("gatewayUrl", "http://" + CtyunHelper.getOosBucketName() + "." + CtyunHelper.getAccessUrl());
            list.add(map);
        }
        return list;
    }

    public Integer delete(String filePath) {
        AmazonS3 oosClient = CtyunHelper.getAmazonS3();
        return CtyunHelper.deleteObject(oosClient, filePath);
    }

    public String getExpiredTime(Integer moduleId, String path, int duration, int timeUnitId, boolean isInternal) {
        String ossBucketName = CtyunHelper.getOssBucketName();
        AmazonS3 amazonS3 = !isInternal ? CtyunHelper.getDefiniteAmazonS3() : CtyunHelper.getDefiniteAmazonS3Internal();
        ExpiredTimeUnit timeName = ExpiredTimeUnit.getTimeName((int)timeUnitId);
        GregorianCalendar calendar = new GregorianCalendar();
        switch (timeName) {
            case MILLISECONDS: {
                calendar.add(14, duration);
                break;
            }
            case SECONDS: {
                calendar.add(13, duration);
                break;
            }
            case MINUTES: {
                calendar.add(12, duration);
                break;
            }
            case HOURS: {
                calendar.add(10, duration);
                break;
            }
            case DAYS: {
                calendar.add(5, duration);
                break;
            }
            default: {
                calendar.add(13, duration);
            }
        }
        Date time = calendar.getTime();
        URL url = amazonS3.generatePresignedUrl(ossBucketName, path, time);
        return url.toString();
    }
}

