/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.storage.broker.service.impl;

import com.ovopark.dc.storage.broker.annotation.StorageTypeAnnotation;
import com.ovopark.dc.storage.broker.common.em.ExpiredTimeUnit;
import com.ovopark.dc.storage.broker.common.em.ModuleEnum;
import com.ovopark.dc.storage.broker.entity.CustResult;
import com.ovopark.dc.storage.broker.service.BaseService;
import com.ovopark.dc.storage.broker.utils.MinioHelper;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MinioClient;
import io.minio.http.Method;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@StorageTypeAnnotation(type=4)
@Service
public class MinioServiceImpl
implements BaseService {
    private static final Logger log = LoggerFactory.getLogger(MinioServiceImpl.class);
    @Autowired
    MinioHelper minioHelper;

    public CustResult upload(Integer moduleId, String fileName, InputStream in, Boolean isDate, String customFilePath, String customFileName) {
        CustResult result;
        MinioClient minioer = MinioHelper.getMinioClient();
        if (moduleId == 4) {
            MinioServiceImpl minioServiceImpl = this;
            result = MinioHelper.putObjectV2ByAmazonS3(minioServiceImpl.minioHelper.getAmazonS3(), moduleId, fileName, in, isDate, customFilePath, customFileName);
        } else {
            result = MinioHelper.putObject(minioer, moduleId, fileName, in, isDate, customFilePath, customFileName);
        }
        return result;
    }

    public Object getOssConfig() {
        ArrayList list = new ArrayList();
        for (ModuleEnum e : ModuleEnum.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("bucket", e.getModuleName());
            map.put("moduleId", e.getModuleId());
            map.put("gatewayUrl", MinioHelper.getOssEndPoint());
            list.add(map);
        }
        return list;
    }

    public Integer delete(String url) {
        return null;
    }

    public String getExpiredTime(Integer moduleId, String path, int duration, int timeUnitId, boolean isInternal) {
        TimeUnit timeUnit;
        MinioClient minioClient = !isInternal ? MinioHelper.getDefiniteMinioClient() : MinioHelper.getDefiniteMinioClientInternal();
        String bucketName = ModuleEnum.getModuleName((int)moduleId);
        ExpiredTimeUnit moduleName = ExpiredTimeUnit.getTimeName((int)timeUnitId);
        switch (moduleName) {
            case MILLISECONDS: {
                timeUnit = TimeUnit.MILLISECONDS;
                break;
            }
            case SECONDS: {
                timeUnit = TimeUnit.SECONDS;
                break;
            }
            case MINUTES: {
                timeUnit = TimeUnit.MINUTES;
                break;
            }
            case HOURS: {
                timeUnit = TimeUnit.HOURS;
                break;
            }
            case DAYS: {
                timeUnit = TimeUnit.DAYS;
                break;
            }
            default: {
                timeUnit = TimeUnit.SECONDS;
            }
        }
        String url = null;
        try {
            url = minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(path)).expiry(duration, timeUnit).build());
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return url;
    }
}

