/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.storage.broker.utils;

import cn.hutool.core.io.file.FileNameUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.ovopark.boot.kit.lang.StrKit;
import com.ovopark.boot.utils.date.DateUtils;
import com.ovopark.dc.storage.broker.common.em.ModuleEnum;
import com.ovopark.dc.storage.broker.prefix.AliyunPrefix;
import com.ovopark.dc.storage.broker.utils.BaseStorageKit;
import com.ovopark.dc.storage.broker.utils.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AliyunHelper {
    private static Logger logger = LoggerFactory.getLogger(AliyunHelper.class);
    public static String accessUrl;
    private static String ossBucketName;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String ossEndPoint;
    private static String definiteEndpoint;
    private static String definiteEndpointInternal;
    @Autowired
    private AliyunPrefix config;
    private static OSSClient ossClients;
    private static OSSClient definiteClients;
    private static OSSClient definiteClientsInternal;
    private static Random random;

    @PostConstruct
    public void init() {
        accessKeyId = this.config.getAccessKeyId();
        accessKeySecret = this.config.getAccessKeySecret();
        ossEndPoint = this.config.getEndpoint();
        ossBucketName = this.config.getMaster().getBucketName();
        accessUrl = this.config.getMaster().getAccessUrl();
        definiteEndpointInternal = this.config.getDefiniteEndpointInternal();
        definiteEndpoint = this.config.getDefiniteEndpoint();
        ossClients = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
        definiteClients = new OSSClient(definiteEndpoint, accessKeyId, accessKeySecret);
        definiteClientsInternal = new OSSClient(definiteEndpointInternal, accessKeyId, accessKeySecret);
    }

    public static OSSClient getAliOssClient() {
        return ossClients;
    }

    public static OSSClient getAliDefiniteClient() {
        return definiteClients;
    }

    public static OSSClient getAliDefiniteClientInternal() {
        return definiteClientsInternal;
    }

    public static String uploadFile(InputStream inputStream, String fileName, Integer moduleId, String customFilePath, String customFileName) {
        boolean b;
        String tempHouzhui = FileNameUtil.extName((String)fileName);
        String houzhui = "";
        if (!StringUtils.isEmpty((Object)tempHouzhui)) {
            houzhui = "." + tempHouzhui;
        }
        String prefix = ModuleEnum.getModuleName((int)moduleId);
        String newFileName = fileName;
        String imagePath = BaseStorageKit.getImagePathWithDate(newFileName);
        if (!StringUtils.isEmpty((Object)customFilePath)) {
            imagePath = customFilePath + "/" + fileName;
            if (!StringUtils.isEmpty((Object)customFileName)) {
                imagePath = customFilePath + "/" + customFileName + houzhui;
                newFileName = customFileName + houzhui;
            }
        } else if (!StringUtils.isEmpty((Object)customFileName)) {
            imagePath = DateUtils.format((Date)new Date(), (String)"yyyy/MM/dd") + "/" + customFileName + houzhui;
            newFileName = customFileName + houzhui;
        }
        if (!StrKit.isBlank((String)prefix)) {
            imagePath = prefix + "/" + imagePath;
        }
        if (!(b = AliyunHelper.putObject(inputStream, newFileName, FileUtil.handelPath(imagePath)))) {
            return null;
        }
        return imagePath;
    }

    public static String uploadLocalFile(String localFilePath) {
        String newFileName = AliyunHelper.genImageName(localFilePath.substring(localFilePath.lastIndexOf("/") + 1));
        String imagePath = BaseStorageKit.getImagePathWithDate(newFileName);
        AliyunHelper.putObject(new File(localFilePath), newFileName, imagePath);
        return imagePath;
    }

    public static InputStream downLoadFile(String imagePath) {
        OSSClient client = AliyunHelper.getAliOssClient();
        InputStream input = null;
        try {
            OSSObject image = client.getObject(ossBucketName, imagePath);
            if (image != null) {
                input = image.getObjectContent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer deleteFile(String filePath) {
        String fileType = StrKit.subAfter((String)filePath, (String)".", (boolean)true);
        if (StrKit.isBlank((String)fileType)) {
            return 401104;
        }
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            client.deleteObject(ossBucketName, filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOssPolicy() {
        OSSClient client = null;
        String dir = "front";
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            long expireTime = 30L;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
            policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
            String postPolicy = client.generatePostPolicy(expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = client.calculatePostSignature(postPolicy);
            LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
            respMap.put("accessid", accessKeyId);
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            respMap.put("dir", dir);
            respMap.put("host", accessUrl);
            respMap.put("expire", String.valueOf(expireEndTime / 1000L));
            String string = JSONObject.toJSONString(respMap);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putObject(File file, String fileName, String imagePath) {
        OSSClient client = null;
        try {
            client = AliyunHelper.getAliOssClient();
            FileInputStream input = new FileInputStream(file);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(BaseStorageKit.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, (InputStream)input, meta);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean putObject(InputStream input, String fileName, String imagePath) {
        OSSClient client = null;
        try {
            client = AliyunHelper.getAliOssClient();
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(BaseStorageKit.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, input, meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public static String genImageName(String suffix) {
        int i = suffix.lastIndexOf(".");
        String extName = null;
        extName = i > 0 ? suffix.substring(i) : suffix;
        long millis = System.currentTimeMillis();
        Random random = new Random();
        int end3 = random.nextInt(999);
        String str = millis + String.format("%03d", end3);
        return str + extName;
    }

    public static String getOssBucketName() {
        return ossBucketName;
    }

    public static String getOssEndPoint() {
        return ossEndPoint;
    }

    public static String getExpiredUrl(String imagePath, Date expiration, boolean isInternal) {
        OSSClient aliOssClient = !isInternal ? AliyunHelper.getAliDefiniteClient() : AliyunHelper.getAliDefiniteClientInternal();
        URL url = aliOssClient.generatePresignedUrl(ossBucketName, imagePath, expiration);
        return url.toString();
    }

    static {
        random = new Random();
    }
}

