/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.storage.broker.utils;

import com.ovopark.boot.utils.date.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BaseStorageKit {
    public static final List<String> list = Stream.of("bmp", "gif", "png", "jpeg", "jpg", "html", "txt", "vsd", "ppt", "pptx", "doc", "docx", "xml", "xls", "xlsx").collect(Collectors.toList());

    public static String getImagePathWithDate(String imageName) {
        return DateUtils.format((Date)new Date(), (String)"yyyy/MM/dd") + "/" + imageName;
    }

    public static String getImagePathNoDate(String imageName) {
        return "noDate/" + imageName;
    }

    public static String contentType(String fileType) {
        fileType = fileType.toLowerCase();
        String contentType = "";
        switch (fileType) {
            case "bmp": {
                contentType = "image/bmp";
                break;
            }
            case "gif": {
                contentType = "image/gif";
                break;
            }
            case "png": 
            case "jpeg": 
            case "jpg": {
                contentType = "image/jpeg";
                break;
            }
            case "html": {
                contentType = "text/html";
                break;
            }
            case "txt": {
                contentType = "text/plain";
                break;
            }
            case "vsd": {
                contentType = "application/vnd.visio";
                break;
            }
            case "ppt": 
            case "pptx": {
                contentType = "application/vnd.ms-powerpoint";
                break;
            }
            case "doc": 
            case "docx": {
                contentType = "application/msword";
                break;
            }
            case "xml": {
                contentType = "text/xml";
                break;
            }
            case "mp4": {
                contentType = "video/mp4";
                break;
            }
            default: {
                contentType = "application/octet-stream";
            }
        }
        return contentType;
    }
}

