/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.storage.broker.utils;

import cn.hutool.core.io.file.FileNameUtil;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.StorageClass;
import com.ovopark.boot.kit.lang.StrKit;
import com.ovopark.boot.utils.date.DateUtils;
import com.ovopark.dc.storage.broker.common.em.ModuleEnum;
import com.ovopark.dc.storage.broker.prefix.CtyunPrefix;
import com.ovopark.dc.storage.broker.utils.BaseStorageKit;
import com.ovopark.dc.storage.broker.utils.FileUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CtyunHelper {
    private static final Logger log = LoggerFactory.getLogger(CtyunHelper.class);
    private static String accessUrl;
    private static String ossBucketName;
    private static String ossEndPoint;
    private static String definiteEndpoint;
    private static String definiteEndpointInternal;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static AmazonS3 ossClient;
    private static AmazonS3 definiteClient;
    private static AmazonS3 definiteClientInternal;
    @Autowired
    private CtyunPrefix config;

    public static String getAccessUrl() {
        return accessUrl;
    }

    public static String getOosBucketName() {
        return ossBucketName;
    }

    @PostConstruct
    public void init() {
        accessKeyId = this.config.getAccessKeyId();
        accessKeySecret = this.config.getAccessKeySecret();
        ossEndPoint = this.config.getEndpoint();
        ossBucketName = this.config.getMaster().getBucketName();
        accessUrl = this.config.getMaster().getAccessUrl();
        definiteEndpoint = this.config.getDefiniteEndpoint();
        definiteEndpointInternal = this.config.getDefiniteEndpointInternal();
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setConnectionTimeout(30000);
        clientConfig.setSocketTimeout(30000);
        clientConfig.setProtocol(Protocol.HTTP);
        S3ClientOptions options = new S3ClientOptions();
        options.setPayloadSigningEnabled(true);
        ossClient = new AmazonS3Client((AWSCredentials)new PropertiesCredentials(accessKeyId, accessKeySecret), clientConfig);
        ossClient.setEndpoint(ossEndPoint);
        ossClient.setS3ClientOptions(options);
        definiteClient = new AmazonS3Client((AWSCredentials)new PropertiesCredentials(accessKeyId, accessKeySecret), clientConfig);
        definiteClient.setEndpoint(definiteEndpoint);
        definiteClient.setS3ClientOptions(options);
        definiteClientInternal = new AmazonS3Client((AWSCredentials)new PropertiesCredentials(accessKeyId, accessKeySecret), clientConfig);
        definiteClientInternal.setEndpoint(definiteEndpointInternal);
        definiteClientInternal.setS3ClientOptions(options);
    }

    public static AmazonS3 getAmazonS3() {
        return ossClient;
    }

    public static AmazonS3 getDefiniteAmazonS3() {
        return definiteClient;
    }

    public static AmazonS3 getDefiniteAmazonS3Internal() {
        return definiteClientInternal;
    }

    public static String putObject(AmazonS3 ossClient, Integer moduleId, String fileName, InputStream in, String customFilePath, String customFileName) {
        String tempHouzhui = FileNameUtil.extName((String)fileName);
        String houzhui = "";
        if (!StringUtils.isEmpty((Object)tempHouzhui)) {
            houzhui = "." + tempHouzhui;
        }
        System.setProperty("com.amazonaws.services.s3.enableV4", "false");
        String newFileName = fileName;
        String prefix = ModuleEnum.getModuleName((int)moduleId);
        String imagePath = BaseStorageKit.getImagePathWithDate(fileName);
        if (!StringUtils.isEmpty((Object)customFilePath)) {
            imagePath = customFilePath + "/" + fileName;
            if (!StringUtils.isEmpty((Object)customFileName)) {
                imagePath = customFilePath + "/" + customFileName + houzhui;
                newFileName = customFileName + houzhui;
            }
        } else if (!StringUtils.isEmpty((Object)customFileName)) {
            imagePath = DateUtils.format((Date)new Date(), (String)"yyyy/MM/dd") + "/" + customFileName + houzhui;
            newFileName = customFileName + houzhui;
        }
        if (!StrKit.isBlank((String)prefix)) {
            imagePath = prefix + "/" + imagePath;
        }
        imagePath = FileUtil.handelPath(imagePath);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentType(BaseStorageKit.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
        meta.setCacheControl("no-cache");
        PutObjectRequest request = new PutObjectRequest(ossBucketName, imagePath, in, meta);
        request.setStorageClass(StorageClass.ReducedRedundancy);
        PutObjectResult result = ossClient.putObject(request);
        System.out.println("put object:" + imagePath + ",md5: " + result.getContentMd5());
        return imagePath;
    }

    public static Integer deleteObject(AmazonS3 oosClient, String filePath) {
        String fileType = StrKit.subAfter((String)filePath, (String)".", (boolean)true);
        if (StrKit.isBlank((String)fileType)) {
            return 401104;
        }
        oosClient.deleteObject(ossBucketName, filePath);
        return 0;
    }

    public static String getOssBucketName() {
        return ossBucketName;
    }

    public static String getOssEndPoint() {
        return ossEndPoint;
    }

    public static String getExpiredUrl(String imagePath, Date expiration) {
        AmazonS3 amazonS3 = CtyunHelper.getAmazonS3();
        URL url = amazonS3.generatePresignedUrl(ossBucketName, imagePath, expiration);
        log.info(url.toString());
        return url.toString();
    }

    public static InputStream downloadFile(String imagePath) {
        AmazonS3 amazonS3 = CtyunHelper.getAmazonS3();
        S3Object object = amazonS3.getObject(ossBucketName, imagePath);
        S3ObjectInputStream objectContent = object.getObjectContent();
        return objectContent;
    }
}

