/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.storage.broker.utils;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.StorageClass;
import com.ovopark.boot.utils.date.DateUtils;
import com.ovopark.dc.storage.broker.common.em.ModuleEnum;
import com.ovopark.dc.storage.broker.common.em.StorageTypeEnum;
import com.ovopark.dc.storage.broker.entity.CustResult;
import com.ovopark.dc.storage.broker.prefix.MinioPrefix;
import com.ovopark.dc.storage.broker.utils.BaseStorageKit;
import com.ovopark.dc.storage.broker.utils.FileUtil;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MinioHelper {
    private static final Logger log = LoggerFactory.getLogger(MinioHelper.class);
    private static String ossBucketName;
    private static String ossEndPoint;
    private static String definiteEndPoint;
    private static String definteEndPointInternal;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String accessUrl;
    private static String accessIntranet;
    private static String https;
    private static MinioClient minioClient;
    private static MinioClient definiteMinioClient;
    private static MinioClient definiteMinioClientInternal;
    private static AmazonS3 ossClient;
    private static AmazonS3 definiteClient;
    private static AmazonS3 definiteClientInternal;
    @Autowired
    private MinioPrefix config;
    @Value(value="${minio-go-web.endpoint}")
    private String minio_go_endpoint;
    @Value(value="${minio-go-web.directory}")
    private String minio_go_directory;

    @PostConstruct
    public void init() {
        accessKeyId = this.config.getAccessKeyId();
        accessKeySecret = this.config.getAccessKeySecret();
        ossEndPoint = this.config.getEndpoint();
        ossBucketName = this.config.getMaster().getBucketName();
        accessUrl = this.config.getMaster().getAccessUrl();
        accessIntranet = this.config.getMaster().getAccessIntranet();
        https = this.config.getMaster().getHttps();
        definiteEndPoint = this.config.getDefiniteEndpoint();
        definteEndPointInternal = this.config.getDefiniteEndpointInternal();
        try {
            minioClient = MinioClient.builder().endpoint(ossEndPoint).credentials(accessKeyId, accessKeySecret).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            definiteMinioClient = MinioClient.builder().endpoint(definiteEndPoint).credentials(accessKeyId, accessKeySecret).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            definiteMinioClientInternal = MinioClient.builder().endpoint(definteEndPointInternal).credentials(accessKeyId, accessKeySecret).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setConnectionTimeout(30000);
        clientConfig.setSocketTimeout(30000);
        clientConfig.setProtocol(Protocol.HTTP);
        S3ClientOptions options = new S3ClientOptions();
        options.setPayloadSigningEnabled(true);
        ossClient = new AmazonS3Client((AWSCredentials)new PropertiesCredentials(accessKeyId, accessKeySecret), clientConfig);
        ossClient.setEndpoint(ossEndPoint);
        ossClient.setS3ClientOptions(options);
        definiteClient = new AmazonS3Client((AWSCredentials)new PropertiesCredentials(accessKeyId, accessKeySecret), clientConfig);
        definiteClient.setEndpoint(definiteEndPoint);
        definiteClient.setS3ClientOptions(options);
        definiteClientInternal = new AmazonS3Client((AWSCredentials)new PropertiesCredentials(accessKeyId, accessKeySecret), clientConfig);
        definiteClientInternal.setEndpoint(definteEndPointInternal);
        definiteClientInternal.setS3ClientOptions(options);
    }

    public static MinioClient getMinioClient() {
        return minioClient;
    }

    public static MinioClient getDefiniteMinioClient() {
        return definiteMinioClient;
    }

    public static MinioClient getDefiniteMinioClientInternal() {
        return definiteMinioClientInternal;
    }

    public static AmazonS3 getAmazonS3() {
        return ossClient;
    }

    public static AmazonS3 getDefiniteAmazonS3() {
        return definiteClient;
    }

    public static AmazonS3 getDefiniteAmazonS3Internal() {
        return definiteClientInternal;
    }

    public static CustResult putObject(MinioClient minioClient, Integer moduleId, String fileName, InputStream in, Boolean isDate, String customFilePath, String customFileName) {
        String prefix;
        String tempHouzhui = FileNameUtil.extName((String)fileName);
        String houzhui = "";
        if (!StringUtils.isEmpty((Object)tempHouzhui)) {
            houzhui = "." + tempHouzhui;
        }
        if (!StringUtils.isEmpty((Object)(prefix = ModuleEnum.getModuleName((int)moduleId)))) {
            if (prefix.length() < 3) {
                prefix = prefix + "x";
                prefix = prefix.toLowerCase();
            }
        } else {
            CustResult result = new CustResult();
            result.setIsFail(Boolean.valueOf(true));
            result.setMsg("\u6876\u4e0d\u5b58\u5728!");
            return result;
        }
        try {
            boolean b = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(prefix)).build());
            if (!b) {
                CustResult result = new CustResult();
                result.setIsFail(Boolean.valueOf(true));
                result.setMsg("\u6876\u4e0d\u5b58\u5728!");
                return result;
            }
        }
        catch (Exception e) {
            log.error("AWS bucketExists: {}", (Object)e.getMessage());
        }
        String key = "";
        if (!StringUtils.isEmpty((Object)customFilePath) && !StringUtils.isEmpty((Object)customFileName)) {
            key = customFilePath + "/" + customFileName + houzhui;
        } else {
            String tempPath;
            key = isDate != false ? BaseStorageKit.getImagePathWithDate(fileName) : BaseStorageKit.getImagePathNoDate(fileName);
            String string = tempPath = isDate != false ? DateUtils.format((Date)new Date(), (String)"yyyy/MM/dd") + "/" : "noDate/";
            if (!StringUtils.isEmpty((Object)customFilePath)) {
                key = customFilePath + "/" + fileName;
            } else if (!StringUtils.isEmpty((Object)customFileName)) {
                key = tempPath + "/" + customFileName + houzhui;
            }
        }
        key = FileUtil.handelPath(key);
        try {
            ObjectWriteResponse test = minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(prefix)).object(key)).stream(in, (long)in.available(), -1L).build());
            CustResult custResult = new CustResult();
            custResult.setAccessUrl(accessUrl + "/" + prefix + "/" + key);
            custResult.setOssUrl(accessUrl + "/" + prefix + "/" + key);
            custResult.setAccessIntranetUrl(accessIntranet + "/" + prefix + "/" + key);
            custResult.setHttps(https + "/" + prefix + "/" + key);
            custResult.setPath(key);
            custResult.setModuleId(moduleId);
            custResult.setStorageType(StorageTypeEnum.minio.getKey());
            return custResult;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static CustResult putObjectV2ByAmazonS3(AmazonS3 ossClient, Integer moduleId, String fileName, InputStream in, Boolean isDate, String customFilePath, String customFileName) {
        String tempHouzhui = FileNameUtil.extName((String)fileName);
        String houzhui = "";
        if (!StringUtils.isEmpty((Object)tempHouzhui)) {
            houzhui = "." + tempHouzhui;
        }
        log.info("\u4f7f\u7528AmazonS3\u5ba2\u6237\u7aef");
        String prefix = ModuleEnum.getModuleName((int)moduleId);
        if (!StringUtils.isEmpty((Object)prefix)) {
            if (prefix.length() < 3) {
                prefix = prefix + "x";
                prefix = prefix.toLowerCase();
            }
        } else {
            CustResult result = new CustResult();
            result.setIsFail(Boolean.valueOf(true));
            result.setMsg("\u6876\u4e0d\u5b58\u5728!");
            return result;
        }
        String key = "";
        if (!StringUtils.isEmpty((Object)customFilePath) && !StringUtils.isEmpty((Object)customFileName)) {
            key = customFilePath + "/" + customFileName + houzhui;
        } else {
            String tempPath;
            key = isDate != false ? BaseStorageKit.getImagePathWithDate(fileName) : BaseStorageKit.getImagePathNoDate(fileName);
            String string = tempPath = isDate != false ? DateUtils.format((Date)new Date(), (String)"yyyy/MM/dd") + "/" : "noDate/";
            if (!StringUtils.isEmpty((Object)customFilePath)) {
                key = customFilePath + "/" + fileName;
            } else if (!StringUtils.isEmpty((Object)customFileName)) {
                key = tempPath + "/" + customFileName + houzhui;
            }
        }
        key = FileUtil.handelPath(key);
        try {
            System.setProperty("com.amazonaws.services.s3.enableV4", "false");
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(BaseStorageKit.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            PutObjectRequest request = new PutObjectRequest(prefix, key, in, meta);
            request.setStorageClass(StorageClass.ReducedRedundancy);
            PutObjectResult result = ossClient.putObject(request);
            CustResult custResult = new CustResult();
            custResult.setAccessUrl(accessUrl + "/" + prefix + "/" + key);
            custResult.setOssUrl(accessUrl + "/" + prefix + "/" + key);
            custResult.setAccessIntranetUrl(accessIntranet + "/" + prefix + "/" + key);
            custResult.setHttps(https + "/" + prefix + "/" + key);
            custResult.setModuleId(moduleId);
            custResult.setPath(key);
            custResult.setStorageType(StorageTypeEnum.minio.getKey());
            return custResult;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CustResult putObjectV2ByGoClient(MinioClient minioClient, Integer moduleId, String fileName, InputStream in, Boolean isDate) {
        String prefix = ModuleEnum.getModuleName((int)moduleId);
        if (prefix.length() < 3) {
            prefix = prefix + "x";
            prefix = prefix.toLowerCase();
        }
        String key = isDate != false ? BaseStorageKit.getImagePathWithDate(fileName) : BaseStorageKit.getImagePathNoDate(fileName);
        try {
            File file;
            boolean newFile;
            HttpRequest post = HttpUtil.createPost((String)this.minio_go_endpoint);
            File directory = new File(this.minio_go_directory);
            if (!directory.exists() && !directory.isDirectory()) {
                log.info(directory + "\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u521b\u5efa");
                boolean mkdir = directory.mkdir();
                if (mkdir) {
                    log.info("\u6587\u4ef6\u5939\u521b\u5efa\u6210\u529f\uff01");
                } else {
                    log.warn("\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25\uff01");
                }
            }
            if (newFile = (file = new File(this.minio_go_directory + "/" + fileName)).createNewFile()) {
                log.info("\u6587\u4ef6\u521b\u5efa\u6210\u529f \uff01");
            }
            this.inputstreamtofile(in, file);
            post.form("file", file);
            String body = post.execute().body();
            JSONObject jsonObject = JSON.parseObject((String)body);
            Object interalUrl = jsonObject.get((Object)"interalUrl");
            Object url = jsonObject.get((Object)"url");
            CustResult custResult = new CustResult();
            custResult.setAccessUrl(url.toString());
            custResult.setAccessIntranetUrl(interalUrl.toString());
            custResult.setHttps(https + "/" + prefix + "/" + key);
            return custResult;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void inputstreamtofile(InputStream ins, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
            ((OutputStream)os).write(buffer, 0, bytesRead);
        }
        ((OutputStream)os).close();
        ins.close();
    }

    public static String getOssBucketName() {
        return ossBucketName;
    }

    public static String getOssEndPoint() {
        return ossEndPoint;
    }

    public static InputStream downloadFile(String moduleName, String imagePath) {
        MinioClient minioClient = MinioHelper.getMinioClient();
        try {
            GetObjectResponse tempStream = minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(moduleName)).object(imagePath)).build());
            return tempStream;
        }
        catch (Exception e) {
            log.error("minio \u4e0b\u8f7d\u51fa\u9519 {}", (Object)e.getMessage());
            return null;
        }
    }
}

