/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.tea.springboot.utils;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class DcTeaBeanDefinitionRegistryUtils {
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    public static void registerBeans(BeanDefinitionRegistry registry, Class<?> ... annotatedClasses) {
        if (ObjectUtils.isEmpty((Object[])annotatedClasses)) {
            return;
        }
        LinkedHashSet classesToRegister = new LinkedHashSet(Arrays.asList(annotatedClasses));
        Iterator iterator = classesToRegister.iterator();
        while (iterator.hasNext()) {
            Class annotatedClass = (Class)iterator.next();
            if (!DcTeaBeanDefinitionRegistryUtils.isPresentBean(registry, annotatedClass)) continue;
            iterator.remove();
        }
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(registry);
        reader.register((Class[])classesToRegister.toArray(EMPTY_CLASS_ARRAY));
    }

    public static boolean isPresentBean(BeanDefinitionRegistry registry, Class<?> annotatedClass) {
        boolean present = false;
        String[] beanNames = registry.getBeanDefinitionNames();
        ClassLoader classLoader = annotatedClass.getClassLoader();
        for (String beanName : beanNames) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (!(beanDefinition instanceof AnnotatedBeanDefinition)) continue;
            AnnotationMetadata annotationMetadata = ((AnnotatedBeanDefinition)beanDefinition).getMetadata();
            String className = annotationMetadata.getClassName();
            Class targetClass = ClassUtils.resolveClassName((String)className, (ClassLoader)classLoader);
            present = ObjectUtils.nullSafeEquals((Object)targetClass, annotatedClass);
        }
        return present;
    }
}

