/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.tea.springboot;

import com.ovopark.dc.tea.em.Client;
import com.ovopark.dc.tea.utils.HttpConstants;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DcTeaConfiguration
implements Serializable {
    private static final long serialVersionUID = 1275096304107045542L;
    private Boolean openlog;
    private Integer clientCode;
    private String configName;
    private Integer connectTimeout;
    private Integer requestTimeout;
    private Charset encoding;
    private Integer maxThreadsTotal;
    private Integer maxThreadsPerHost;
    private static final Map<String, DcTeaConfiguration> CONFIGURATION_CACHE = new ConcurrentHashMap<String, DcTeaConfiguration>();
    private static final DcTeaConfiguration defaultConfiguration = DcTeaConfiguration.configuration();

    public static DcTeaConfiguration configuration() {
        return DcTeaConfiguration.configuration("teaConfiguration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DcTeaConfiguration configuration(String configName) {
        DcTeaConfiguration configuration = CONFIGURATION_CACHE.get(configName);
        if (configuration != null) return CONFIGURATION_CACHE.get(configName);
        Class<DcTeaConfiguration> clazz = DcTeaConfiguration.class;
        synchronized (DcTeaConfiguration.class) {
            if (CONFIGURATION_CACHE.containsKey(configName)) return CONFIGURATION_CACHE.get(configName);
            configuration = DcTeaConfiguration.createConfiguration();
            configuration.setConfigName(configName);
            CONFIGURATION_CACHE.put(configName, configuration);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return CONFIGURATION_CACHE.get(configName);
        }
    }

    public static void setConfiguration(DcTeaConfiguration configuration) {
        DcTeaConfiguration.setConfiguration(configuration, "teaConfiguration");
    }

    private static void setConfiguration(DcTeaConfiguration configuration, String configName) {
        if (configuration == null) {
            CONFIGURATION_CACHE.put(configName, configuration);
        }
    }

    private static DcTeaConfiguration createConfiguration() {
        DcTeaConfiguration config = new DcTeaConfiguration();
        config.setClientCode(Client.Tea.getCode());
        config.setConfigName("tea-Config");
        config.setEncoding(HttpConstants.UTF_8);
        config.setConnectTimeout(HttpConstants.connectTimeout);
        config.setRequestTimeout(HttpConstants.requestTimeout);
        config.setMaxThreadsTotal(HttpConstants.maxThreadsTotal);
        config.setMaxThreadsPerHost(HttpConstants.maxThreadsPerHost);
        config.setOpenlog(false);
        return config;
    }

    public Integer getClientCode() {
        return this.clientCode;
    }

    public void setClientCode(Integer clientCode) {
        this.clientCode = clientCode;
    }

    public static DcTeaConfiguration getDefaultconfiguration() {
        return defaultConfiguration;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public Integer getMaxThreadsTotal() {
        return this.maxThreadsTotal;
    }

    public void setMaxThreadsTotal(Integer maxThreadsTotal) {
        this.maxThreadsTotal = maxThreadsTotal;
    }

    public Integer getMaxThreadsPerHost() {
        return this.maxThreadsPerHost;
    }

    public void setMaxThreadsPerHost(Integer maxThreadsPerHost) {
        this.maxThreadsPerHost = maxThreadsPerHost;
    }

    public Boolean getOpenlog() {
        return this.openlog;
    }

    public void setOpenlog(Boolean openlog) {
        this.openlog = openlog;
    }
}

