/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.tea.springboot;

import com.ovopark.dc.tea.parser.UrlParser;
import com.ovopark.dc.tea.springboot.DcTeaConfiguration;
import com.ovopark.dc.tea.springboot.DcTeaProperties;
import com.ovopark.dc.tea.springboot.autoconfigure.DcTeaBeanDefinitionRegistrar;
import com.ovopark.dc.tea.springboot.extend.EnvironmentUrlParser;
import com.ovopark.dc.tea.utils.ConvertUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(value="dcTeaAutoConfiguration")
@EnableConfigurationProperties(value={DcTeaProperties.class})
public class DcTeaAutoConfiguration {
    @Autowired(required=false)
    private ConfigurableApplicationContext applicationContext;
    private static final Boolean openlog = false;
    private static final Integer clientCode = 3;

    @Bean
    public DcTeaBeanDefinitionRegistrar getDcTeaConfiguration(DcTeaProperties properties) {
        DcTeaConfiguration config = DcTeaConfiguration.configuration();
        config.setOpenlog(ConvertUtils.toBoolean((Object)properties.getOpenlog(), (Boolean)openlog));
        config.setClientCode(ConvertUtils.toInt((Object)properties.getClientCode(), (Integer)clientCode));
        config.setProxy(properties.getProxy());
        DcTeaConfiguration.setConfiguration(config);
        DcTeaBeanDefinitionRegistrar beandefinition = new DcTeaBeanDefinitionRegistrar(this.applicationContext, config);
        beandefinition.registerScanner();
        return beandefinition;
    }

    @Bean
    UrlParser urlConverter(Environment environment) {
        return new EnvironmentUrlParser(environment);
    }
}

