/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.tea.springboot.autoconfigure;

import com.ovopark.dc.tea.http.DcGateWayApi;
import com.ovopark.dc.tea.http.DcHttpApi;
import com.ovopark.dc.tea.proxy.TeaProxyContext;
import com.ovopark.dc.tea.springboot.proxy.TeaFactoryBean;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class DcTeaComponentScanner
extends ClassPathBeanDefinitionScanner {
    private static final Logger log = LoggerFactory.getLogger(DcTeaComponentScanner.class);
    private static final Class<?> TEA_FACTORY_BEAN_CLASS = TeaFactoryBean.class;
    private TeaProxyContext teaProxyContext;

    public DcTeaComponentScanner(BeanDefinitionRegistry registry, boolean useDefaultFilters) {
        super(registry, useDefaultFilters);
    }

    protected void registerFilters() {
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(DcHttpApi.class));
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(DcGateWayApi.class));
    }

    protected void setProxyContext(TeaProxyContext teaProxyContext) {
        this.teaProxyContext = teaProxyContext;
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitionHolders = super.doScan(basePackages);
        if (beanDefinitionHolders.size() != 0) {
            this.processBeanDefinitions(beanDefinitionHolders);
        }
        return beanDefinitionHolders;
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            String beanClassName = definition.getBeanClassName();
            definition.setBeanClass(TEA_FACTORY_BEAN_CLASS);
            definition.getPropertyValues().add("teaProxyContext", (Object)this.teaProxyContext);
            definition.getPropertyValues().add("interfaceClass", (Object)beanClassName);
            log.info("[Tea] Created interface '{}'  proxy object bean '{}'", (Object)beanClassName, (Object)holder.getBeanName());
        }
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }
}

