/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.tea.springboot.autoconfigure;

import com.ovopark.dc.tea.Tea;
import com.ovopark.dc.tea.base.TeaHttpHost;
import com.ovopark.dc.tea.kit.TeaKit;
import com.ovopark.dc.tea.parser.UrlParser;
import com.ovopark.dc.tea.proxy.TeaProxyContext;
import com.ovopark.dc.tea.springboot.DcTeaConfiguration;
import com.ovopark.dc.tea.springboot.autoconfigure.DcTeaComponentScanRegistrar;
import com.ovopark.dc.tea.springboot.autoconfigure.DcTeaComponentScanner;
import java.util.List;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

public class DcTeaBeanDefinitionRegistrar
implements BeanPostProcessor {
    private final ConfigurableApplicationContext applicationContext;
    private DcTeaConfiguration configuration;

    public DcTeaBeanDefinitionRegistrar(ConfigurableApplicationContext applicationContext, DcTeaConfiguration config) {
        this.applicationContext = applicationContext;
        this.configuration = config;
    }

    public void registerScanner() {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        DcTeaComponentScanner scanner = new DcTeaComponentScanner(registry, false);
        scanner.registerFilters();
        scanner.setProxyContext(this.getProxyContext());
        scanner.doScan(StringUtils.toStringArray(DcTeaComponentScanRegistrar.getBasePackages()));
    }

    protected TeaProxyContext getProxyContext() {
        UrlParser urlParser;
        TeaProxyContext context = Tea.drink().getTeaProxyContext();
        TeaKit.openLog((boolean)this.configuration.getOpenlog(), (List)context.interceptors);
        Integer clientCode = this.configuration.getClientCode();
        TeaHttpHost proxy = this.configuration.getProxy();
        context.client = TeaKit.getClientByCode((Integer)clientCode, (TeaHttpHost)proxy);
        context.urlParser = urlParser = (UrlParser)this.applicationContext.getBean(UrlParser.class);
        return context;
    }
}

