/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk;

import com.ovopark.dc.log.kafka.producer.sdk.InitializeBeforeContainerInitializationQueue;
import com.ovopark.dc.log.kafka.producer.sdk.MyRoundRobinPartitioner;
import com.ovopark.dc.log.kafka.producer.sdk.util.ApplicationUtil;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.beans.factory.InitializingBean;

public class CommonKafkaProducer
implements InitializingBean {
    private final Producer<String, String> producer;
    private Thread worker;

    public CommonKafkaProducer() {
        Properties kafkaProperties = new Properties();
        kafkaProperties.put("partitioner.class", MyRoundRobinPartitioner.class.getName());
        kafkaProperties.put("acks", "0");
        kafkaProperties.put("bootstrap.servers", "47.98.217.98:19091,47.98.167.121:19091");
        kafkaProperties.put("key.serializer", StringSerializer.class);
        kafkaProperties.put("value.serializer", StringSerializer.class);
        kafkaProperties.put("linger.ms", (Object)10);
        kafkaProperties.put("compression.type", "lz4");
        kafkaProperties.put("retries", "3");
        this.producer = new KafkaProducer(kafkaProperties);
        this.initWorker();
    }

    public static CommonKafkaProducer getInstance() {
        return (CommonKafkaProducer)ApplicationUtil.getBean(CommonKafkaProducer.class);
    }

    private void initWorker() {
        this.worker = new Thread(this::run);
        this.worker.setName("log-kafka-producer");
        this.worker.start();
    }

    private void run() {
        while (true) {
            ProducerRecord<String, String> record;
            if (Objects.isNull(record = InitializeBeforeContainerInitializationQueue.getInstance().poll())) {
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.producer.send(record);
        }
    }

    public void afterPropertiesSet() throws Exception {
        System.err.println("[CommonKafkaProducer] init CommonKafkaProducer ...");
    }
}

