/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum LogSource {
    JAVA("Java", "ovo_log_run", "dc-log:robot:java"),
    INVOKE_TIME("Invoke Time", "ovo_api_invoke_time", null),
    EXCEPTION_CATCHER("Exception Catcher", "ovo_exception_catcher", null),
    SLOW_QUERY("MySQL", "ovo_slow_query_index", "dc-log:robot:slow-query");

    private final String name;
    private final String index;
    private final String robotKey;
    private static final List<String> NAME_LIST;
    private static final List<String> INDEX_LIST;
    private static final Map<String, LogSource> MAP;

    private LogSource(String name, String index, String robotKey) {
        this.name = name;
        this.index = index;
        this.robotKey = robotKey;
    }

    public String getName() {
        return this.name;
    }

    public String getIndex() {
        return this.index;
    }

    public static List<String> getNameList() {
        return NAME_LIST;
    }

    public String getRobotKey() {
        return this.robotKey;
    }

    public static String getIndex(String name) {
        return MAP.get(name).getIndex();
    }

    public static String getRobotKey(String name) {
        return LogSource.MAP.get((Object)name).robotKey;
    }

    public static List<String> getIndexList() {
        return INDEX_LIST;
    }

    public static LogSource getByName(String name) {
        return MAP.get(name);
    }

    static {
        NAME_LIST = new ArrayList<String>(4);
        INDEX_LIST = new ArrayList<String>(4);
        MAP = new HashMap<String, LogSource>(4, 1.0f);
        for (LogSource logSource : LogSource.values()) {
            INDEX_LIST.add(logSource.index);
            MAP.put(logSource.name, logSource);
            NAME_LIST.add(logSource.name);
        }
    }
}

