/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.processor;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;

public class EnvironmentHolder {
    private static final String SPRING_APPLICATION_NAME_KEY = "spring.application.name";
    private static final String DUBBO_APPLICATION_NAME_KEY = "dubbo.application.name";
    private static final String SPRING_PROFILES_ACTIVE_KEY = "spring.profiles.active";
    private static final String APOLLO_ENV_KEY = "apollo.env";
    private static final String SPRING_CLOUD_PROFILE_KEY = "spring.cloud.profile";
    private static final String SERVER_PORT_KEY = "server.port";
    private static Environment env;

    protected static void init(Environment env) {
        EnvironmentHolder.env = env;
    }

    private static String getProperty(String key) {
        if (Objects.isNull(env)) {
            return "undefined";
        }
        return env.getProperty(key);
    }

    public static String port() {
        return EnvironmentHolder.getProperty(SERVER_PORT_KEY) == null ? "8080" : EnvironmentHolder.getProperty(SERVER_PORT_KEY);
    }

    public static String applicationName() {
        if (StringUtils.isNotBlank((CharSequence)EnvironmentHolder.getProperty(SPRING_APPLICATION_NAME_KEY))) {
            return EnvironmentHolder.getProperty(SPRING_APPLICATION_NAME_KEY);
        }
        if (StringUtils.isNotBlank((CharSequence)EnvironmentHolder.getProperty(DUBBO_APPLICATION_NAME_KEY))) {
            return EnvironmentHolder.getProperty(DUBBO_APPLICATION_NAME_KEY);
        }
        return "undefined";
    }

    public static String activeProfile() {
        if (StringUtils.isNotBlank((CharSequence)EnvironmentHolder.getProperty(SPRING_PROFILES_ACTIVE_KEY))) {
            return EnvironmentHolder.getProperty(SPRING_PROFILES_ACTIVE_KEY);
        }
        if (StringUtils.isNotBlank((CharSequence)EnvironmentHolder.getProperty(SPRING_CLOUD_PROFILE_KEY))) {
            return EnvironmentHolder.getProperty(SPRING_CLOUD_PROFILE_KEY);
        }
        if (StringUtils.isNotBlank((CharSequence)EnvironmentHolder.getProperty(APOLLO_ENV_KEY))) {
            return EnvironmentHolder.getProperty(APOLLO_ENV_KEY);
        }
        return "undefined";
    }
}

