/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ResourceUtil {
    private static final String CLASSPATH_PREFIX = "classpath:";

    public static URL getResourceUrl(String resource) throws IOException {
        if (resource.startsWith(CLASSPATH_PREFIX)) {
            URL url;
            String path = resource.substring(CLASSPATH_PREFIX.length());
            ClassLoader classLoader = ResourceUtil.class.getClassLoader();
            URL uRL = url = classLoader != null ? classLoader.getResource(path) : ClassLoader.getSystemResource(path);
            if (url == null) {
                throw new FileNotFoundException("Resource [" + resource + "] does not exist");
            }
            return url;
        }
        try {
            return new URL(resource);
        }
        catch (MalformedURLException ex) {
            return new File(resource).toURI().toURL();
        }
    }
}

