/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.appender;

import com.ovopark.dc.log.kafka.producer.sdk.InitializeBeforeContainerInitializationQueue;
import com.ovopark.dc.log.kafka.producer.sdk.model.LogModel;
import com.ovopark.dc.log.kafka.producer.sdk.processor.EnvironmentHolder;
import com.ovopark.dc.log.kafka.producer.sdk.util.ExceptionUtil;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class Log4jKafkaAppender
extends AppenderSkeleton {
    public static final String DELIM_STR = "{}";

    public static LogModel getLogMessage(LoggingEvent loggingEvent) {
        String formattedMessage = Log4jKafkaAppender.getMessage(loggingEvent);
        Level logLevel = loggingEvent.getLevel();
        LogModel logModel = LogModel.build(formattedMessage, loggingEvent.getTimeStamp());
        if (logModel.notLoadExceptionInfo()) {
            logModel.setClassName(loggingEvent.getLoggerName());
            LocationInfo locationInfo = loggingEvent.getLocationInformation();
            String method = locationInfo.getMethodName();
            String line = locationInfo.getLineNumber();
            logModel.setMethod(method + "(" + locationInfo.getFileName() + ":" + line + ")");
        }
        logModel.setLogLevel(logLevel.toString());
        return Log4jKafkaAppender.pourMDCInfo(logModel, loggingEvent);
    }

    private static LogModel pourMDCInfo(LogModel autoPushLog, LoggingEvent logEvent) {
        Map mdc = logEvent.getProperties();
        if (mdc != null && !mdc.isEmpty()) {
            autoPushLog.putMdc(mdc);
        }
        return autoPushLog;
    }

    private static String getMessage(LoggingEvent logEvent) {
        if (logEvent.getLevel().toInt() == 40000) {
            String msg = "";
            if (logEvent.getThrowableInformation() != null) {
                msg = ExceptionUtil.stacktraceToString(logEvent.getThrowableInformation().getThrowable());
            }
            if (logEvent.getRenderedMessage() != null && logEvent.getRenderedMessage().contains(DELIM_STR)) {
                FormattingTuple format = MessageFormatter.format((String)logEvent.getRenderedMessage(), (Object)msg);
                return format.getMessage();
            }
            return logEvent.getRenderedMessage() + "\n" + msg;
        }
        return logEvent.getRenderedMessage();
    }

    protected void append(LoggingEvent loggingEvent) {
        LogModel logModel = Log4jKafkaAppender.getLogMessage(loggingEvent);
        InitializeBeforeContainerInitializationQueue.getInstance().send("dc_log_list", EnvironmentHolder.applicationName(), logModel);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

