/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.schedule;

import com.ovopark.dc.log.kafka.producer.sdk.trace.TraceContext;
import com.ovopark.dc.log.kafka.producer.sdk.util.IdWorker;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SpringScheduledTaskAspect {
    private static final IdWorker ID_WORKER = new IdWorker(1L, 1L, 1L);

    @Pointcut(value="@annotation(org.springframework.scheduling.annotation.Scheduled)")
    public void cut() {
    }

    @Around(value="cut()")
    public Object around(ProceedingJoinPoint jp) throws Throwable {
        try {
            TraceContext.getCurrentContext().setTraceId(String.valueOf(ID_WORKER.nextId()));
            Object object = jp.proceed();
            return object;
        }
        finally {
            TraceContext.getCurrentContext().remove();
        }
    }
}

