/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.trace;

import com.alibaba.fastjson.JSON;
import com.ovopark.dc.log.kafka.producer.sdk.trace.TraceContext;
import com.ovopark.dc.log.kafka.producer.sdk.util.IdWorker;
import com.ovopark.dc.log.kafka.producer.sdk.util.StrUtil;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebRequestTraceFilter
implements Filter {
    private static final IdWorker ID_WORKER = new IdWorker(1L, 1L, 1L);

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        try {
            TraceContext.getCurrentContext().setRequestTime(System.currentTimeMillis());
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            Enumeration headers = request.getHeaderNames();
            HashMap<String, String> headerMap = new HashMap<String, String>();
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                headerMap.put(header, request.getHeader(header));
            }
            String traceId = request.getHeader("dc-log-trace-id");
            String uri = request.getRequestURI();
            TraceContext.getCurrentContext().setHeader(JSON.toJSONString(headerMap));
            TraceContext.getCurrentContext().setUri(uri);
            TraceContext.getCurrentContext().setTraceId(StrUtil.isBlank(traceId) ? String.valueOf(ID_WORKER.nextId()) : traceId);
            response.addHeader("dc-log-trace-id", traceId);
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (Exception exception) {
        }
        finally {
            TraceContext.getCurrentContext().remove();
        }
    }

    public void destroy() {
    }
}

