/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.util;

import com.ovopark.dc.log.kafka.producer.sdk.util.CollectionUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import org.springframework.util.CollectionUtils;

public class NetUtil {
    private static String hostIp = null;

    public static String getHostIp() {
        try {
            InetAddress localhost;
            if (null == hostIp && null != (localhost = NetUtil.getLocalhost())) {
                hostIp = localhost.getHostAddress();
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        return hostIp;
    }

    public static InetAddress getLocalhost() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(address -> !address.isLoopbackAddress() && !address.isSiteLocalAddress() && address instanceof Inet4Address);
        if (!CollectionUtils.isEmpty(localAddressList)) {
            return CollectionUtil.findFirst(localAddressList);
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LinkedHashSet<InetAddress> localAddressList(Filter<InetAddress> addressFilter) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
        if (networkInterfaces == null) {
            throw new IllegalStateException("Get network interface error!");
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressFilter && !addressFilter.accept(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    private static interface Filter<T> {
        public boolean accept(T var1);
    }
}

