/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.web;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.ovopark.dc.log.kafka.producer.sdk.InitializeBeforeContainerInitializationQueue;
import com.ovopark.dc.log.kafka.producer.sdk.model.InvokeTimeModel;
import com.ovopark.dc.log.kafka.producer.sdk.processor.EnvironmentHolder;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class WebInvokeTimeFilter
implements Filter {
    private static final TransmittableThreadLocal<Long> INVOKE_TIME_TL = new TransmittableThreadLocal();

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        INVOKE_TIME_TL.set((Object)System.currentTimeMillis());
        filterChain.doFilter(request, response);
        long invokeTime = System.currentTimeMillis() - (Long)INVOKE_TIME_TL.get();
        InvokeTimeModel invokeTimeModel = InvokeTimeModel.build(invokeTime, (Long)INVOKE_TIME_TL.get());
        InitializeBeforeContainerInitializationQueue.getInstance().send("dc_invoke_time", EnvironmentHolder.applicationName(), invokeTimeModel.toString());
        INVOKE_TIME_TL.remove();
    }

    public void destroy() {
    }
}

