/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.appender;

import com.ovopark.dc.log.kafka.producer.sdk.InitializeBeforeContainerInitializationQueue;
import com.ovopark.dc.log.kafka.producer.sdk.model.LogModel;
import com.ovopark.dc.log.kafka.producer.sdk.processor.EnvironmentHolder;
import com.ovopark.dc.log.kafka.producer.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;

@Plugin(name="Log4j2KafkaAppender", category="Core", elementType="appender", printObject=true)
public class Log4j2KafkaAppender
extends AbstractAppender {
    public static final String DELIM_STR = "{}";

    protected Log4j2KafkaAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    @PluginFactory
    public static Log4j2KafkaAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        return new Log4j2KafkaAppender(name, filter, layout, true);
    }

    private static LogModel getLogMessage(LogEvent logEvent) {
        Level logLevel = logEvent.getLevel();
        String formattedMessage = Log4j2KafkaAppender.getMessage(logEvent);
        LogModel logModel = LogModel.build(formattedMessage, logEvent.getTimeMillis());
        if (logModel.notLoadExceptionInfo()) {
            logModel.setClassName(logEvent.getLoggerName());
            StackTraceElement stackTraceElement = logEvent.getSource();
            String method = stackTraceElement.getMethodName();
            String line = String.valueOf(stackTraceElement.getLineNumber());
            logModel.setMethod(method + "(" + stackTraceElement.getFileName() + ":" + line + ")");
        }
        logModel.setLogLevel(logLevel.toString());
        return Log4j2KafkaAppender.pourMDCInfo(logModel, logEvent);
    }

    private static LogModel pourMDCInfo(LogModel autoPushLog, LogEvent logEvent) {
        Map mdc = logEvent.getContextData().toMap();
        if (mdc != null && !mdc.isEmpty()) {
            autoPushLog.putMdc(mdc);
        }
        return autoPushLog;
    }

    private static String getMessage(LogEvent logEvent) {
        if (logEvent.getLevel().equals((Object)Level.ERROR)) {
            Throwable thrown = logEvent.getThrown();
            String formatMessage = logEvent.getMessage().getFormat();
            Object[] args = logEvent.getMessage().getParameters();
            if (args != null) {
                int l = args.length;
                for (int i = 0; i < l; ++i) {
                    if (i == l - 1 && args[i] == thrown || !(args[i] instanceof Throwable)) continue;
                    args[i] = ExceptionUtil.stacktraceToString((Throwable)args[i]);
                }
                formatMessage = Log4j2KafkaAppender.packageMessage(formatMessage, args);
            }
            if (thrown != null) {
                return Log4j2KafkaAppender.packageMessage(formatMessage, new String[]{ExceptionUtil.stacktraceToString(thrown)});
            }
            return formatMessage;
        }
        return logEvent.getMessage().getFormattedMessage();
    }

    private static String packageMessage(String formatMessage, Object[] args) {
        if (formatMessage != null && formatMessage.contains(DELIM_STR)) {
            return ParameterizedMessageFactory.INSTANCE.newMessage(formatMessage, args).getFormattedMessage();
        }
        StringBuilder builder = new StringBuilder(128);
        builder.append(formatMessage);
        for (Object arg : args) {
            builder.append("\n").append(arg);
        }
        return builder.toString();
    }

    public void append(LogEvent logEvent) {
        LogModel logModel = Log4j2KafkaAppender.getLogMessage(logEvent);
        InitializeBeforeContainerInitializationQueue.getInstance().send("dc_log_list", EnvironmentHolder.applicationName(), logModel);
    }
}

