/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.appender;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import com.ovopark.dc.log.kafka.producer.sdk.InitializeBeforeContainerInitializationQueue;
import com.ovopark.dc.log.kafka.producer.sdk.model.LogModel;
import com.ovopark.dc.log.kafka.producer.sdk.processor.EnvironmentHolder;
import com.ovopark.dc.log.kafka.producer.sdk.util.ExceptionUtil;
import java.util.Map;
import java.util.Objects;
import org.slf4j.helpers.MessageFormatter;

public class LogbackKafkaAppender
extends AppenderBase<ILoggingEvent> {
    private static final String DELIM_STR = "{}";

    public static LogModel getLogMessage(ILoggingEvent iLoggingEvent) {
        String formattedMessage = LogbackKafkaAppender.getMessage(iLoggingEvent);
        Level logLevel = iLoggingEvent.getLevel();
        LogModel logModel = LogModel.build(formattedMessage, iLoggingEvent.getTimeStamp());
        if (logModel.notLoadExceptionInfo()) {
            logModel.setClassName(iLoggingEvent.getLoggerName());
            StackTraceElement stackTraceElement = iLoggingEvent.getCallerData()[0];
            String method = stackTraceElement.getMethodName();
            String line = String.valueOf(stackTraceElement.getLineNumber());
            logModel.setMethod(method + "(" + stackTraceElement.getFileName() + ":" + line + ")");
        }
        logModel.setLogLevel(logLevel.toString());
        return LogbackKafkaAppender.pourMDCInfo(logModel, iLoggingEvent);
    }

    private static LogModel pourMDCInfo(LogModel logModel, ILoggingEvent iLoggingEvent) {
        Map mdc = iLoggingEvent.getMDCPropertyMap();
        if (mdc != null && !mdc.isEmpty()) {
            logModel.putMdc(mdc);
        }
        return logModel;
    }

    private static String getMessage(ILoggingEvent logEvent) {
        Object[] args;
        if (logEvent.getThrowableProxy() != null) {
            ThrowableProxy throwableProxy = (ThrowableProxy)logEvent.getThrowableProxy();
            Object[] args2 = new String[]{ExceptionUtil.stacktraceToString(throwableProxy.getThrowable())};
            return LogbackKafkaAppender.packageMessage(logEvent.getMessage(), args2);
        }
        Level level = logEvent.getLevel();
        if (level != null && level.isGreaterOrEqual(Level.WARN) && (args = logEvent.getArgumentArray()) != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Throwable)) continue;
                args[i] = ExceptionUtil.stacktraceToString((Throwable)args[i]);
            }
            return LogbackKafkaAppender.packageMessage(logEvent.getMessage(), args);
        }
        return logEvent.getFormattedMessage();
    }

    private static String packageMessage(String message, Object[] args) {
        if (message != null && message.contains(DELIM_STR)) {
            return MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        }
        StringBuilder builder = new StringBuilder(128);
        builder.append(message);
        for (Object arg : args) {
            builder.append("\n").append(arg);
        }
        return builder.toString();
    }

    protected void append(ILoggingEvent event) {
        LogModel logModel = LogbackKafkaAppender.getLogMessage(event);
        if (Objects.equals(event.getLoggerName(), "dc.log.exception")) {
            logModel.setAppName("log_" + logModel.getAppName());
        }
        InitializeBeforeContainerInitializationQueue.getInstance().send("dc_log_list", EnvironmentHolder.applicationName(), logModel);
    }

    public void start() {
        super.start();
    }
}

