/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.model;

import com.ovopark.dc.log.kafka.producer.sdk.common.LogSource;
import com.ovopark.dc.log.kafka.producer.sdk.model.ExceptionModel;
import com.ovopark.dc.log.kafka.producer.sdk.processor.EnvironmentHolder;
import com.ovopark.dc.log.kafka.producer.sdk.trace.TraceContext;
import com.ovopark.dc.log.kafka.producer.sdk.util.NetUtil;
import java.util.HashMap;
import java.util.Map;

public class LogModel {
    private String uri;
    private String active;
    private String className;
    private String method;
    private String args;
    private String spanId;
    private String port;
    private String traceId;
    private Map<String, Object> mdc;
    private String logLevel;
    private Long dtTime;
    private String serverIp;
    private String content;
    private String source;
    private String appName;

    public static LogModel build(String message, long time) {
        LogModel logModel = new LogModel();
        logModel.setServerIp(NetUtil.getHostIp());
        logModel.setAppName(EnvironmentHolder.applicationName());
        logModel.setContent(message.trim());
        logModel.setDtTime(time);
        logModel.setActive(EnvironmentHolder.activeProfile());
        logModel.setPort(EnvironmentHolder.port());
        logModel.setSource(LogSource.JAVA.getName());
        logModel.setUri(TraceContext.getCurrentContext().getUri());
        logModel.setTraceId(TraceContext.getCurrentContext().getTraceId());
        logModel.setMethod(TraceContext.getCurrentContext().getMethod());
        logModel.setClassName(TraceContext.getCurrentContext().getClazz());
        logModel.setArgs(TraceContext.getCurrentContext().getArgs());
        return logModel;
    }

    public static LogModel buildAround(String message, long time) {
        LogModel logModel = new LogModel();
        logModel.setServerIp(NetUtil.getHostIp());
        logModel.setAppName(EnvironmentHolder.applicationName());
        logModel.setContent(message.trim());
        logModel.setDtTime(time);
        logModel.setActive(EnvironmentHolder.activeProfile());
        logModel.setPort(EnvironmentHolder.port());
        logModel.setSource(LogSource.JAVA.getName());
        logModel.setUri(TraceContext.getCurrentContext().getUri());
        logModel.setTraceId(TraceContext.getCurrentContext().getTraceId());
        logModel.setMethod(TraceContext.getCurrentContext().getMethod());
        logModel.setClassName(TraceContext.getCurrentContext().getClazz());
        logModel.setArgs(TraceContext.getCurrentContext().getArgs());
        logModel.setLogLevel("INFO");
        return logModel;
    }

    public static LogModel buildFromException(ExceptionModel exceptionModel) {
        LogModel logModel = new LogModel();
        logModel.setServerIp(exceptionModel.getServerIp());
        logModel.setAppName(exceptionModel.getAppName());
        logModel.setContent(exceptionModel.getMessage());
        logModel.setDtTime(exceptionModel.getDtTime());
        logModel.setActive(exceptionModel.getActive());
        logModel.setPort(exceptionModel.getPort());
        logModel.setSource(LogSource.JAVA.getName());
        logModel.setUri(TraceContext.getCurrentContext().getUri());
        logModel.setTraceId(exceptionModel.getTraceId());
        logModel.setSpanId("0");
        logModel.setMethod(exceptionModel.getMethod());
        logModel.setClassName(exceptionModel.getClassName());
        logModel.setArgs(TraceContext.getCurrentContext().getArgs());
        logModel.setLogLevel("ERROR");
        return logModel;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Map<String, Object> getMdc() {
        return this.mdc;
    }

    public void setMdc(Map<String, Object> mdc) {
        this.mdc = mdc;
    }

    public void putMdc(String key, Object value) {
        if (this.mdc == null) {
            this.mdc = new HashMap<String, Object>();
        }
        this.mdc.put(key, value);
    }

    public void putMdc(Map<String, ?> map) {
        if (this.mdc == null) {
            this.mdc = new HashMap<String, Object>(map.size());
        }
        this.mdc.putAll(map);
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean notLoadExceptionInfo() {
        return this.method == null || this.className == null;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public Long getDtTime() {
        return this.dtTime;
    }

    public void setDtTime(Long dtTime) {
        this.dtTime = dtTime;
    }
}

