/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.trace;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class TraceContext
extends ConcurrentHashMap<String, Object> {
    public static final String TRACE_ID = "traceId";
    public static final String URI = "uri";
    public static final String HEADER = "header";
    public static final String ARGS = "args";
    public static final String CLASS = "class";
    public static final String METHOD = "method";
    public static final String REQUEST_TIME = "requestTime";
    public static final String RESPONSE_TIME = "responseTime";
    public static final Set<String> UNCOLLECTIBLE_URLS = new HashSet<String>();
    public static final String REQUEST_THROWABLE = "requestThrowable";
    protected static Class<? extends TraceContext> traceContextClass = TraceContext.class;
    private static final TransmittableThreadLocal<TraceContext> TRACE_CONTEXT_TTL = new TransmittableThreadLocal<TraceContext>(){

        protected TraceContext initialValue() {
            try {
                return traceContextClass.newInstance();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static boolean withArgs = true;

    public static TraceContext getCurrentContext() {
        return (TraceContext)TRACE_CONTEXT_TTL.get();
    }

    public Throwable getRequestThrowable() {
        Object obj = this.get(REQUEST_THROWABLE);
        if (obj != null) {
            return (Throwable)obj;
        }
        return null;
    }

    public void setRequestThrowable(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        this.put(REQUEST_THROWABLE, throwable);
    }

    public Long getRequestTime() {
        Object obj = this.get(REQUEST_TIME);
        if (obj != null) {
            return Long.parseLong(obj.toString());
        }
        return null;
    }

    public void setRequestTime(Long timeMs) {
        if (timeMs == null) {
            return;
        }
        this.put(REQUEST_TIME, timeMs);
    }

    public Long getResponseTime() {
        Object obj = this.get(RESPONSE_TIME);
        if (obj != null) {
            return Long.parseLong(obj.toString());
        }
        return null;
    }

    public void setResponseTime(Long timeMs) {
        if (timeMs == null) {
            return;
        }
        this.put(RESPONSE_TIME, timeMs);
    }

    public boolean getWithArgs() {
        return withArgs;
    }

    public void setWithArgs(boolean withArgs) {
        TraceContext.withArgs = withArgs;
    }

    public void addUncollectibleUrl(Set<String> url) {
        UNCOLLECTIBLE_URLS.addAll(url);
    }

    public boolean isUncollectibleUrl(String uri) {
        if (StringUtils.isNotBlank((CharSequence)uri) && uri.charAt(uri.length() - 1) == '-') {
            uri = uri.substring(0, uri.length() - 1);
        }
        return UNCOLLECTIBLE_URLS.contains(uri);
    }

    public String getClazz() {
        Object obj = this.get(CLASS);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public void setClazz(String clazz) {
        if (StringUtils.isBlank((CharSequence)clazz)) {
            return;
        }
        this.put(CLASS, clazz);
    }

    public String getMethod() {
        Object obj = this.get(METHOD);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public void setMethod(String method) {
        if (StringUtils.isBlank((CharSequence)method)) {
            return;
        }
        this.put(METHOD, method);
    }

    public String getTraceId() {
        Object obj = this.get(TRACE_ID);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public void setTraceId(String traceId) {
        if (StringUtils.isBlank((CharSequence)traceId)) {
            return;
        }
        this.put(TRACE_ID, traceId);
    }

    public String getUri() {
        Object obj = this.get(URI);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public void setUri(String uri) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return;
        }
        this.put(URI, uri);
    }

    public String getHeader() {
        Object obj = this.get(HEADER);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public void setHeader(String header) {
        if (StringUtils.isBlank((CharSequence)header)) {
            return;
        }
        this.put(HEADER, header);
    }

    public String getArgs() {
        Object obj = this.get(ARGS);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public void setArgs(String args) {
        if (StringUtils.isBlank((CharSequence)args)) {
            return;
        }
        this.put(ARGS, args);
    }

    public void remove() {
        TRACE_CONTEXT_TTL.remove();
        this.clear();
    }
}

