/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.util;

import com.ovopark.dc.log.kafka.producer.sdk.util.ArrayUtil;
import com.ovopark.dc.log.kafka.producer.sdk.util.StrFormatter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.util.StringUtils;

public class StrUtil {
    public static final String NULL = "null";
    public static final String EMPTY = "";

    public static String toCamelCase(String str) {
        if (StringUtils.hasLength((String)str)) {
            StringBuilder sb = new StringBuilder(str.length());
            boolean shouldCamel = false;
            for (int i = 0; i < str.length(); ++i) {
                Character ch = StrUtil.alphaOrNumber(Character.valueOf(str.charAt(i)), shouldCamel);
                if (ch == null) {
                    shouldCamel = true;
                    continue;
                }
                sb.append(ch);
                shouldCamel = false;
            }
            return sb.toString();
        }
        return str;
    }

    public static boolean containsLetterOrDigit(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isLetterOrDigit(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static Character alphaOrNumber(Character ch, boolean shouldCamel) {
        if (ch.charValue() >= 'a' && ch.charValue() <= 'z') {
            if (shouldCamel) {
                return Character.valueOf((char)(ch.charValue() - 32));
            }
            return ch;
        }
        if (ch.charValue() >= '0' && ch.charValue() <= '9') {
            return ch;
        }
        if (ch.charValue() >= 'A' && ch.charValue() <= 'Z') {
            if (shouldCamel) {
                return ch;
            }
            return Character.valueOf((char)(ch.charValue() + 32));
        }
        return null;
    }

    public static boolean endWith(String str, String prefix) {
        if (str == null || prefix == null) {
            return false;
        }
        return str.endsWith(prefix);
    }

    public static String subPre(CharSequence string, int toIndexExclude) {
        return StrUtil.sub(string, 0, toIndexExclude);
    }

    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        if (!StringUtils.hasLength((CharSequence)str)) {
            return StrUtil.str(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return EMPTY;
        }
        return str.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static String asUTFString(byte[] content) {
        return StrUtil.asUTFString(content, 0, content.length);
    }

    public static String asUTFString(byte[] content, int offset, int length) {
        return content == null || length == 0 ? EMPTY : new String(content, offset, length, StandardCharsets.UTF_8);
    }

    public static byte[] toUTF(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return NULL;
        }
        if (ArrayUtil.isEmpty(params) || StrUtil.isBlank(template)) {
            return template.toString();
        }
        return StrFormatter.format(template.toString(), params);
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StrUtil.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StrUtil.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StrUtil.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtil.isArray(obj)) {
            return ArrayUtil.toString(obj);
        }
        return obj.toString();
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StrUtil.str(bytes, charset);
    }

    public static boolean notBlank(Object str) {
        if (str == null) {
            return false;
        }
        return !StrUtil.isBlank(str.toString());
    }

    public static boolean notBlank(String str) {
        return !StrUtil.isBlank(str);
    }

    public static boolean isBlank(Object str) {
        return !StrUtil.notBlank(str);
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (StrUtil.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0;
    }

    public static boolean containLetterOrDigit(CharSequence str) {
        if (str != null) {
            int sz = str.length();
            for (int i = 0; i < sz; ++i) {
                if (!Character.isLetterOrDigit(str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Object a, String b) {
        if (a == null || b == null) {
            return false;
        }
        String aStr = a.toString();
        return aStr.contains(b);
    }
}

