/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.web;

import com.alibaba.fastjson.JSON;
import com.ovopark.dc.log.kafka.producer.sdk.InitializeBeforeContainerInitializationQueue;
import com.ovopark.dc.log.kafka.producer.sdk.model.ExceptionModel;
import com.ovopark.dc.log.kafka.producer.sdk.model.InvokeRecord;
import com.ovopark.dc.log.kafka.producer.sdk.model.LogModel;
import com.ovopark.dc.log.kafka.producer.sdk.processor.EnvironmentHolder;
import com.ovopark.dc.log.kafka.producer.sdk.trace.TraceContext;
import com.ovopark.dc.log.kafka.producer.sdk.util.ExceptionUtil;
import com.ovopark.dc.log.kafka.producer.sdk.util.NetUtil;
import com.ovopark.dc.log.kafka.producer.sdk.util.RequestUtil;
import com.ovopark.dc.log.kafka.producer.sdk.web.IgnoreException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class GlobalExceptionAspect
implements InitializingBean {
    @Autowired
    private IgnoreException ignoreException;
    private List<String> ignoreExceptions = new ArrayList<String>();

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.ExceptionHandler)")
    public void exceptionPointcut() {
    }

    @Before(value="exceptionPointcut()")
    public void beforeException(JoinPoint joinPoint) {
        try {
            Object[] args;
            for (Object arg : args = joinPoint.getArgs()) {
                if (!(arg instanceof Exception)) continue;
                Exception ex = (Exception)arg;
                if (!this.ignoreExceptions.contains(ex.getClass().getCanonicalName())) {
                    StackTraceElement stackTraceElement = ex.getStackTrace()[0];
                    String method = stackTraceElement.getMethodName();
                    String line = String.valueOf(stackTraceElement.getLineNumber());
                    String clazz = stackTraceElement.getClassName();
                    this.sneakyExceptionLog(ex, clazz, method, line);
                    method = method + "(" + stackTraceElement.getFileName() + ":" + line + ")";
                    TraceContext.getCurrentContext().setClazz(clazz);
                    TraceContext.getCurrentContext().setMethod(method);
                    ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                    if (attributes == null) continue;
                    HttpServletRequest request = attributes.getRequest();
                    String uri = request.getRequestURI();
                    if (TraceContext.getCurrentContext().isUncollectibleUrl(uri)) {
                        TraceContext.getCurrentContext().setArgs(null);
                        continue;
                    }
                    if (TraceContext.getCurrentContext().getArgs() != null) continue;
                    TraceContext.getCurrentContext().setArgs(RequestUtil.getArgsByRequest(request));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterReturning(value="exceptionPointcut()", returning="result")
    public void afterException(Object result) {
        Throwable bizThrowable = TraceContext.getCurrentContext().getRequestThrowable();
        if (bizThrowable != null) {
            TraceContext.getCurrentContext().setResponseTime(System.currentTimeMillis());
            InvokeRecord invokeRecord = new InvokeRecord(TraceContext.getCurrentContext().getHeader(), TraceContext.getCurrentContext().getArgs(), JSON.toJSONString((Object)result));
            LogModel logModel = LogModel.buildAround(invokeRecord.buildContent(), System.currentTimeMillis());
            InitializeBeforeContainerInitializationQueue.getInstance().send("dc_log_list", EnvironmentHolder.applicationName(), logModel);
        }
    }

    private void sneakyExceptionLog(Exception ex, String clazz, String method, String line) {
        ExceptionModel catcher = new ExceptionModel();
        catcher.exception = ex.getClass().getName();
        catcher.method = method;
        catcher.className = clazz;
        catcher.line = line;
        catcher.dtTime = System.currentTimeMillis();
        catcher.message = ExceptionUtil.stacktraceToString(ex);
        catcher.traceId = TraceContext.getCurrentContext().getTraceId();
        catcher.port = EnvironmentHolder.port();
        catcher.appName = EnvironmentHolder.applicationName();
        catcher.active = EnvironmentHolder.activeProfile();
        catcher.serverIp = NetUtil.getHostIp();
        InitializeBeforeContainerInitializationQueue.getInstance().send("dc_log_list", EnvironmentHolder.applicationName(), JSON.toJSONString((Object)LogModel.buildFromException(catcher)));
    }

    public void afterPropertiesSet() throws Exception {
        String ignoreEx = this.ignoreException.getExceptions();
        if (StringUtils.hasLength((String)ignoreEx)) {
            String[] exs = ignoreEx.split(",");
            this.ignoreExceptions = Arrays.asList(exs);
        }
    }
}

