/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.web;

import com.alibaba.fastjson.JSON;
import com.ovopark.dc.log.kafka.producer.sdk.trace.TraceContext;
import com.ovopark.dc.log.kafka.producer.sdk.util.RequestUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Aspect
public class PreRequestAspect {
    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.Mapping) || @annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) ||@annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping)")
    public void argsPointcut() {
    }

    @Before(value="argsPointcut()")
    public void beforeController(JoinPoint joinPoint) {
        try {
            String className = joinPoint.getTarget().getClass().getCanonicalName();
            String methodName = joinPoint.getSignature().getName();
            TraceContext.getCurrentContext().setMethod(methodName);
            TraceContext.getCurrentContext().setClazz(className);
            Object[] argValues = joinPoint.getArgs();
            String[] argNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
            if (argNames == null || argValues == null) {
                return;
            }
            HashMap<String, Object> argMap = new HashMap<String, Object>(argNames.length);
            for (int i = 0; i < argNames.length; ++i) {
                Object argValue = argValues[i];
                if (argValue instanceof HttpServletRequest) {
                    Map parameterMap = ((HttpServletRequest)argValue).getParameterMap();
                    argMap.putAll(RequestUtil.convertQueryArgsMap(parameterMap));
                    continue;
                }
                if (argValue instanceof MultipartFile) {
                    MultipartFile multipartFile = (MultipartFile)argValue;
                    String fileValue = multipartFile.getOriginalFilename() + "[" + multipartFile.getSize() + "(bytes)]";
                    argMap.put(argNames[i], fileValue);
                    continue;
                }
                argMap.put(argNames[i], argValue);
            }
            if (!CollectionUtils.isEmpty(argMap)) {
                TraceContext.getCurrentContext().setArgs(JSON.toJSONString(argMap));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

