/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class CollectionUtil {
    public static <T> T get(Collection<T> collection, int index) {
        if (null == collection) {
            return null;
        }
        int size = collection.size();
        if (0 == size) {
            return null;
        }
        if (index < 0) {
            index += size;
        }
        if (index >= size || index < 0) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(index);
        }
        int i = 0;
        for (T t : collection) {
            if (i > index) break;
            if (i == index) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<T>(collection);
    }

    public static <T, R> List<T> distinctAsList(Collection<T> collection, Function<T, R> function) {
        if (CollectionUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        if (collection.size() == 1) {
            return new ArrayList<T>(collection);
        }
        HashSet<R> set = new HashSet<R>();
        LinkedList<T> list = new LinkedList<T>();
        for (T t : collection) {
            R r = function.apply(t);
            if (!set.add(r)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> toList(Collection<T> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> merge(List<T> a, List<T> b) {
        LinkedList<T> list = new LinkedList<T>();
        if (CollectionUtil.notEmpty(a)) {
            list.addAll(a);
        }
        if (CollectionUtil.notEmpty(b)) {
            list.addAll(b);
        }
        return list;
    }

    public static <T> boolean notEmpty(Collection<T> list) {
        return list != null && !list.isEmpty();
    }

    public static <T> boolean isEmpty(Collection<T> list) {
        return list == null || list.isEmpty();
    }

    public static <T> T findAny(Collection<T> collection) {
        return CollectionUtil.findAny(collection, null);
    }

    public static <T> T findAny(Collection<T> collection, T other) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return collection.stream().findAny().orElse(other);
    }

    public static <T> T findFirst(Collection<T> collection, T other) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return collection.stream().findFirst().orElse(other);
    }

    public static <T> T findFirst(Collection<T> collection) {
        return CollectionUtil.findFirst(collection, null);
    }
}

