/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.log.kafka.producer.sdk.web;

import com.alibaba.fastjson.JSON;
import com.ovopark.dc.log.kafka.producer.sdk.InitializeBeforeContainerInitializationQueue;
import com.ovopark.dc.log.kafka.producer.sdk.model.InvokeRecord;
import com.ovopark.dc.log.kafka.producer.sdk.model.LogModel;
import com.ovopark.dc.log.kafka.producer.sdk.processor.EnvironmentHolder;
import com.ovopark.dc.log.kafka.producer.sdk.trace.TraceContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.InitializingBean;

@Aspect
public class WebInvokeRecordAspect
implements InitializingBean {
    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.Mapping) || @annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) ||@annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping)")
    public void argsPointcut() {
    }

    @Around(value="argsPointcut()")
    public Object run(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        Object result = null;
        Throwable bizThrowable = null;
        try {
            result = joinPoint.proceed(args);
        }
        catch (Throwable throwable) {
            bizThrowable = throwable;
            TraceContext.getCurrentContext().setRequestThrowable(throwable);
            throw throwable;
        }
        if (bizThrowable == null) {
            TraceContext.getCurrentContext().setResponseTime(System.currentTimeMillis());
            InvokeRecord invokeRecord = new InvokeRecord(TraceContext.getCurrentContext().getHeader(), TraceContext.getCurrentContext().getArgs(), JSON.toJSONString((Object)result));
            LogModel logModel = LogModel.buildAround(invokeRecord.buildContent(), System.currentTimeMillis());
            InitializeBeforeContainerInitializationQueue.getInstance().send("dc_log_list", EnvironmentHolder.applicationName(), logModel);
        }
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        System.err.println("[WebInvokeRecordAspect] Init WebInvokeRecordAspect , all interface invoke will be proxied to record both request and response.");
    }
}

