/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.apigetway.sdk.client;

import com.ovopark.dc.apigetway.sdk.client.HttpClientUtil;
import com.ovopark.dc.apigetway.sdk.config.OpenplatformConst;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OvoParkHttpClient {
    private static final String USER_AGENT_VALUE = "Mozilla/4.0 (compatible; MSIE 6.0; Windows XP)";
    private static final String Environment = "environment";
    private String method = "POST";
    private String errInfo = "";
    private String charset = "UTF-8";
    private int responseCode = 0;
    private String OpenEnvironment;
    private InputStream inputStream = null;
    private int timeOut = 30;
    private String reqContent = "";
    private String resContent = "";
    private Map<String, String> headers = new HashMap<String, String>();
    private String contentType = "application/x-www-form-urlencoded;charset=utf-8";

    public OvoParkHttpClient() {
        this.headers.put(Environment, OpenplatformConst.Environment.FORMAL.getValue());
    }

    public boolean call() {
        boolean isRet = false;
        try {
            this.callHttp();
            isRet = true;
        }
        catch (IOException e) {
            this.errInfo = e.getMessage();
        }
        return isRet;
    }

    protected void callHttp() throws IOException {
        if ("POST".equals(this.method.toUpperCase()) || "PUT".equals(this.method.toUpperCase()) || "DELETE".equals(this.method.toUpperCase())) {
            if (this.contentType.equals("application/x-www-form-urlencoded;charset=utf-8")) {
                this.doFormUrlencoded();
            } else {
                this.doJson();
            }
        } else {
            this.httpGetMethod(this.reqContent);
        }
    }

    protected void doFormUrlencoded() throws IOException {
        String url = HttpClientUtil.getURL(this.reqContent);
        String queryString = HttpClientUtil.getQueryString(this.reqContent);
        byte[] postData = queryString.getBytes(this.charset);
        HttpURLConnection conn = HttpClientUtil.getHttpURLConnection(url);
        conn.setRequestMethod(this.method.toUpperCase());
        this.setHttpRequest(conn);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        Set<String> keys = this.headers.keySet();
        for (String key : keys) {
            String value = this.headers.get(key);
            conn.setRequestProperty(key, value);
        }
        BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
        int len = 1024;
        HttpClientUtil.doOutput(out, postData, 1024);
        out.close();
        this.responseCode = conn.getResponseCode();
        this.inputStream = conn.getInputStream();
    }

    protected void httpGetMethod(String url) throws IOException {
        HttpURLConnection httpConnection = HttpClientUtil.getHttpURLConnection(url);
        this.setHttpRequest(httpConnection);
        httpConnection.setRequestMethod("GET");
        Set<String> keys = this.headers.keySet();
        for (String key : keys) {
            String value = this.headers.get(key);
            httpConnection.setRequestProperty(key, value);
        }
        this.responseCode = httpConnection.getResponseCode();
        this.inputStream = httpConnection.getInputStream();
    }

    protected void doJson() throws IOException {
        String url = HttpClientUtil.getURL(this.reqContent);
        HttpURLConnection conn = HttpClientUtil.getHttpURLConnection(url);
        String jsonData = HttpClientUtil.getJson(this.reqContent);
        conn.setRequestMethod(this.method.toUpperCase());
        this.setHttpRequest(conn);
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Charset", "UTF-8");
        conn.setRequestProperty("Content-Type", "application/json;charset=utf-8");
        Set<String> keys = this.headers.keySet();
        for (String key : keys) {
            String value = this.headers.get(key);
            conn.setRequestProperty(key, value);
        }
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        out.writeBytes(jsonData);
        out.flush();
        out.close();
        this.responseCode = conn.getResponseCode();
        this.inputStream = conn.getInputStream();
    }

    protected void setHttpRequest(HttpURLConnection httpConnection) {
        httpConnection.setConnectTimeout(this.timeOut * 1000);
        httpConnection.setRequestProperty("User-Agent", USER_AGENT_VALUE);
        httpConnection.setUseCaches(false);
        httpConnection.setDoInput(true);
        httpConnection.setDoOutput(true);
    }

    public String getResContent() {
        try {
            this.doResponse();
        }
        catch (IOException e) {
            this.errInfo = e.getMessage();
            return "";
        }
        return this.resContent;
    }

    protected void doResponse() throws IOException {
        if (this.inputStream == null) {
            return;
        }
        this.resContent = HttpClientUtil.InputStreamTOString(this.inputStream, this.charset);
        this.inputStream.close();
    }

    public void setReqContent(String reqContent) {
        this.reqContent = reqContent;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setHeaders(String key, String value) {
        this.headers.put(key, value);
    }

    public String getOpenEnvironment() {
        return this.OpenEnvironment;
    }

    public void setOpenEnvironment(String openEnvironment) {
        this.OpenEnvironment = openEnvironment;
        this.headers.put(Environment, this.OpenEnvironment);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getErrInfo() {
        return this.errInfo;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

