/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.apigetway.sdk.handler;

import com.ovopark.dc.apigetway.sdk.kit.PoJoKit;
import com.ovopark.dc.apigetway.sdk.kit.StrKit;
import com.ovopark.dc.apigetway.sdk.kit.UrlKit;
import com.ovopark.dc.apigetway.sdk.utils.OvoParkUtils;
import com.ovopark.dc.apigetway.sdk.utils.SignUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.text.StringEscapeUtils;

public class RequestHandler {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private SortedMap<String, Object> parameters = new TreeMap<String, Object>();
    private String gateUrl = "";
    private String method = "";
    private String appId = "";
    private String applicationKey = "";
    private String applicationSecret = "";
    private String debugInfo = "";
    private boolean jsonUnescape = false;
    private String version;
    private String requestMode;

    public String getParameter(String parameter) {
        String s = (String)this.parameters.get(parameter);
        return s == null ? "" : s;
    }

    public void setParameter(String parameter, String parameterValue) {
        String v = "";
        if (parameterValue != null) {
            v = parameterValue.trim();
        }
        this.parameters.put(parameter, v);
    }

    public void setPoJo(Object pojo) {
        Field[] fields;
        Class<?> clazz = pojo.getClass();
        Field[] fieldArray = fields = PoJoKit.getNeedFields(clazz);
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                String v = "";
                field.setAccessible(true);
                String key = field.getName();
                Object value = field.get(pojo);
                if (value != null) {
                    v = value.toString().trim();
                }
                this.parameters.put(key, v);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public String getGateUrl() {
        return this.gateUrl;
    }

    public void setGateUrl(String gateUrl) {
        this.gateUrl = gateUrl;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public String getApplicationSecret() {
        return this.applicationSecret;
    }

    public void setApplicationSecret(String applicationSecret) {
        this.applicationSecret = applicationSecret;
    }

    protected void createSign(boolean unescape) {
        String requestMode;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getApplicationSecret());
        this.parameters.put("_aid", this.getAppId());
        this.parameters.put("_mt", this.getMethod());
        this.parameters.put("_akey", this.getApplicationKey());
        String version = this.getVersion();
        if (!StrKit.isBlank(version)) {
            this.parameters.put("_version", version);
        }
        if (!StrKit.isBlank(requestMode = this.getRequestMode())) {
            this.parameters.put("_requestMode", requestMode);
        }
        Set<Map.Entry<String, Object>> es = this.parameters.entrySet();
        for (Map.Entry<String, Object> entry : es) {
            String k = entry.getKey();
            String v = (String)entry.getValue();
            if (unescape && k.equals("data")) {
                v = StringEscapeUtils.unescapeJava((String)v);
                v = UrlKit.encode(v, "UTF-8");
            }
            if ("_sig".equals(k)) continue;
            sb.append(String.valueOf(k) + v);
        }
        sb.append(this.getApplicationSecret());
        String str = sb.toString();
        String sign_method = this.getParameter("_sm");
        String sign = SignUtils.sign(sign_method, str);
        this.setParameter("_sig", sign);
        this.setDebugInfo(String.valueOf(str) + " => sign:" + sign);
    }

    public String getRequestURL() {
        boolean flag = this.isJsonUnescape();
        this.createSign(flag);
        StringBuffer sb = new StringBuffer();
        String enc = this.getCharset();
        Set<Map.Entry<String, Object>> es = this.parameters.entrySet();
        for (Map.Entry<String, Object> entry : es) {
            String k = entry.getKey();
            String v = (String)entry.getValue();
            if (flag) {
                k = StringEscapeUtils.unescapeJava((String)k);
                v = StringEscapeUtils.unescapeJava((String)v);
            }
            try {
                sb.append(String.valueOf(k) + "=" + URLEncoder.encode(v, enc) + "&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        String reqPars = sb.substring(0, sb.lastIndexOf("&"));
        return String.valueOf(this.getGateUrl()) + "?" + reqPars;
    }

    protected String getCharset() {
        return OvoParkUtils.getCharacterEncoding(this.request, this.response);
    }

    protected void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
    }

    public SortedMap<String, Object> getAllParameters() {
        return this.parameters;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public boolean isJsonUnescape() {
        return this.jsonUnescape;
    }

    public void setJsonUnescape(boolean jsonUnescape) {
        this.jsonUnescape = jsonUnescape;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRequestMode() {
        return this.requestMode;
    }

    public void setRequestMode(String requestMode) {
        this.requestMode = requestMode;
    }
}

