/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.apigetway.sdk.utils;

import com.ovopark.dc.apigetway.sdk.kit.StrKit;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class ConvertUtils {
    public static String toStr(Object value) {
        return ConvertUtils.toStr(value, null);
    }

    public static String toStr(Object value, String defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static Integer toInt(Object result) {
        return ConvertUtils.toInt(result, null);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        try {
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            String strValue = (String)value;
            if (StrKit.isBlank(strValue = strValue.trim())) {
                return defaultValue;
            }
            if (strValue.startsWith("N") || strValue.startsWith("n")) {
                return -Integer.parseInt(strValue.substring(1));
            }
            return Integer.parseInt(strValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long toLong(Object value) {
        return ConvertUtils.toLong(value, null);
    }

    public static Long toLong(Object value, Long defaultValue) {
        try {
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            String strValue = (String)value;
            if (StrKit.isBlank(strValue = strValue.trim())) {
                return defaultValue;
            }
            if (strValue.startsWith("N") || strValue.startsWith("n")) {
                return -Long.parseLong(strValue.substring(1));
            }
            return Long.parseLong(strValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigDecimal toBigDecimal(Object value) {
        return ConvertUtils.toBigDecimal(value, null);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        try {
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Long) {
                return new BigDecimal((Long)value);
            }
            if (value instanceof Double) {
                return new BigDecimal((Double)value);
            }
            if (value instanceof Integer) {
                return new BigDecimal((Integer)value);
            }
            String strValue = (String)value;
            if (StrKit.isBlank(strValue = strValue.trim())) {
                return defaultValue;
            }
            return new BigDecimal(strValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Double toDouble(Object value) {
        return ConvertUtils.toDouble(value, null);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        try {
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            String strValue = (String)value;
            if (StrKit.isBlank(strValue = strValue.trim())) {
                return defaultValue;
            }
            return new BigDecimal(strValue).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Float toFloat(Object value) {
        return ConvertUtils.toFloat(value, null);
    }

    public static Float toFloat(Object value, Float defaultValue) {
        try {
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Float) {
                return (Float)value;
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            String strValue = (String)value;
            if (StrKit.isBlank(strValue = strValue.trim())) {
                return defaultValue;
            }
            return Float.valueOf(Float.parseFloat(strValue));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String encode(String value, String charset) {
        if (StrKit.isBlank(value)) {
            return "";
        }
        try {
            return URLEncoder.encode(value, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encode  error:" + e.getMessage());
        }
    }

    public static String decode(String value, String charset) {
        if (StrKit.isBlank(value)) {
            return "";
        }
        try {
            return URLDecoder.decode(value, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("decode error:" + e.getMessage());
        }
    }

    public static Boolean toBoolean(Object value) {
        return ConvertUtils.toBoolean(value, null);
    }

    public static Boolean toBoolean(Object value, Boolean defaultValue) {
        try {
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            String strValue = (String)value;
            if (StrKit.isBlank(strValue = strValue.trim())) {
                return defaultValue;
            }
            return Boolean.parseBoolean(strValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

