/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.apigetway.sdk.utils;

import com.ovopark.dc.apigetway.sdk.utils.Base64Util;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;

public class RsaUtil {
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";

    public static ConcurrentHashMap<String, String> createKeys() {
        ConcurrentHashMap<String, String> data = new ConcurrentHashMap<String, String>();
        try {
            KeyPairGenerator keyPairGeno = KeyPairGenerator.getInstance("RSA");
            keyPairGeno.initialize(1024);
            KeyPair keyPair = keyPairGeno.generateKeyPair();
            RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
            String publicKey = Base64Util.encodeToString(rsaPublicKey.getEncoded());
            String privateKey = Base64Util.encodeToString(rsaPrivateKey.getEncoded());
            System.out.println("\u516c\u94a5\uff1a" + publicKey);
            System.out.println("\u79c1\u94a5\uff1a" + privateKey);
            data.put(PUBLIC_KEY, publicKey);
            data.put(PRIVATE_KEY, privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return data;
    }

    public static RSAPublicKey getPublicKey(String pubKey) {
        return RsaUtil.getPublicKey(Base64Util.decode(pubKey));
    }

    public static RSAPublicKey getPublicKey(byte[] pubKeyData) {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pubKeyData);
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)factory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RSAPrivateKey getPrivateKey(String priKey) {
        return RsaUtil.getPrivateKey(Base64Util.decode(priKey));
    }

    public static RSAPrivateKey getPrivateKey(byte[] keyBytes) {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)factory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptByPublicKey(String data, String publicKey) {
        return RsaUtil.encryptByPublicKey(data, RsaUtil.getPublicKey(publicKey));
    }

    public static String encryptByPublicKey(String data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            byte[] bytes = cipher.doFinal(data.getBytes("UTF-8"));
            return Base64Util.encodeToString(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptByPrivateKey(String data, String privateKey) {
        return RsaUtil.decryptByPrivateKey(data, RsaUtil.getPrivateKey(privateKey));
    }

    public static String decryptByPrivateKey(String data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            byte[] inputData = Base64Util.decode(data);
            byte[] bytes = cipher.doFinal(inputData);
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

