package com.ovopark.dc.apigetway.sdk.handler;


import com.ovopark.dc.apigetway.sdk.config.OpenplatformConst;
import com.ovopark.dc.apigetway.sdk.kit.DateKit;

import java.util.Date;
import java.util.Map;
import java.util.UUID;


/**
 * @author Remi Jo
 */
public class GwInitRequestHandler extends RequestHandler{

	public GwInitRequestHandler() {
		super();
	}
	public void init() {
		this.setParameter("_sm",OpenplatformConst.Sm.MD5.getValue());
		this.setParameter("_requestMode", OpenplatformConst.RequestMode.POST.getValue());
		this.setParameter("_version", OpenplatformConst.VERSION);
		this.setParameter("_timestamp", DateKit.DateTime2Str(new Date(), DateKit.getSampleTimeFormat()));
		//签名
		this.setParameter("_sig", "");
		this.setParameter("_nonce",UUID.randomUUID().toString());
		this.setParameter("_format", "json");
	}
	public void createSign() {
		super.createSign(false);
		this.setParameter("_sig", getParameter("_sig").toUpperCase());
	}

	public static GwInitRequestHandler of(Map<String, String> map) {
		GwInitRequestHandler handler = new GwInitRequestHandler();
		handler.init();
		map.forEach((k, v) -> {
			if ("_aid".equals(k)) {
				handler.setAppId(v);
			} else if ("_sm".equals(k)) {
				handler.setSignatureMethod(v);
			} else if ("_version".equals(k)) {
				handler.setVersion(v);
			} else if ("_akey".equals(k)) {
				handler.setApplicationKey(v);
			} else if ("_asid".equals(k)) {
				handler.setApplicationSecret(v);
			} else if ("_mt".equals(k)) {
				handler.setMethod(v);
			} else if ("_requestMode".equals(k)) {
				handler.setRequestMode(v);
			} else {
				handler.setParameter(k, v);
			}
		});
		return handler;
	}

}
