/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.apigetway.sdk.handler;

import com.ovopark.dc.apigetway.sdk.config.OpenplatformConst;
import com.ovopark.dc.apigetway.sdk.handler.RequestHandler;
import com.ovopark.dc.apigetway.sdk.kit.DateKit;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

public class GwInitRequestHandler
extends RequestHandler {
    public void init() {
        this.setParameter("_sm", OpenplatformConst.Sm.MD5.getValue());
        this.setParameter("_requestMode", OpenplatformConst.RequestMode.POST.getValue());
        this.setParameter("_version", "v1");
        this.setParameter("_timestamp", DateKit.DateTime2Str(new Date(), DateKit.getSampleTimeFormat()));
        this.setParameter("_sig", "");
        this.setParameter("_nonce", UUID.randomUUID().toString());
        this.setParameter("_format", "json");
    }

    public void createSign() {
        super.createSign(false);
        this.setParameter("_sig", this.getParameter("_sig").toUpperCase());
    }

    public static GwInitRequestHandler of(Map<String, String> map) {
        GwInitRequestHandler handler = new GwInitRequestHandler();
        handler.init();
        map.forEach((k, v) -> {
            if ("_aid".equals(k)) {
                handler.setAppId((String)v);
            } else if ("_sm".equals(k)) {
                handler.setSignatureMethod((String)v);
            } else if ("_version".equals(k)) {
                handler.setVersion((String)v);
            } else if ("_akey".equals(k)) {
                handler.setApplicationKey((String)v);
            } else if ("_asid".equals(k)) {
                handler.setApplicationSecret((String)v);
            } else if ("_mt".equals(k)) {
                handler.setMethod((String)v);
            } else if ("_requestMode".equals(k)) {
                handler.setRequestMode((String)v);
            } else {
                handler.setParameter((String)k, (String)v);
            }
        });
        return handler;
    }
}

