/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.apigetway.sdk.handler;

import com.ovopark.dc.apigetway.sdk.kit.PoJoKit;
import com.ovopark.dc.apigetway.sdk.kit.RSASignatureKit;
import com.ovopark.dc.apigetway.sdk.kit.StrKit;
import com.ovopark.dc.apigetway.sdk.kit.UrlKit;
import com.ovopark.dc.apigetway.sdk.utils.OvoParkUtils;
import com.ovopark.dc.apigetway.sdk.utils.SignUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.text.StringEscapeUtils;

public class RequestHandler {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private final SortedMap<String, Object> parameters = new TreeMap<String, Object>();
    private String gateUrl = "";
    private String method = "";
    private String appId = "";
    private String applicationKey = "";
    private String applicationSecret = "";
    private String debugInfo = "";
    private boolean jsonUnescape = false;
    private String version;
    private String requestMode;
    private String signatureMethod;
    private String rsaPrivateKey;
    private boolean ignoreSignature = false;

    public String getParameter(String parameter) {
        String s = (String)this.parameters.get(parameter);
        return null == s ? "" : s;
    }

    public void setParameter(String parameter, String parameterValue) {
        String v = "";
        if (null != parameterValue) {
            v = parameterValue.trim();
        }
        this.parameters.put(parameter, v);
    }

    public void setPoJo(Object pojo) {
        Field[] fields;
        Class<?> clazz = pojo.getClass();
        for (Field field : fields = PoJoKit.getNeedFields(clazz)) {
            try {
                String v = "";
                field.setAccessible(true);
                String key = field.getName();
                Object value = field.get(pojo);
                if (null != value) {
                    v = value.toString().trim();
                }
                this.parameters.put(key, v);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public String getGateUrl() {
        return this.gateUrl;
    }

    public void setGateUrl(String gateUrl) {
        this.gateUrl = gateUrl;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public String getApplicationSecret() {
        return this.applicationSecret;
    }

    public void setApplicationSecret(String applicationSecret) {
        this.applicationSecret = applicationSecret;
    }

    protected void ignoreSign() {
        this.parameters.put("_mt", this.getMethod());
        this.parameters.put("_aid", this.getAppId());
    }

    protected void createSign(boolean unescape) {
        String requestMode;
        StringBuilder sb = new StringBuilder();
        String signatureMethod = this.getSignatureMethod();
        if (!StrKit.isBlank(signatureMethod)) {
            this.setParameter("_sm", signatureMethod);
        } else {
            signatureMethod = this.getParameter("_sm");
        }
        if (!"rsa".equals(signatureMethod)) {
            sb.append(this.getApplicationSecret());
            this.parameters.put("_akey", this.getApplicationKey());
        }
        this.parameters.put("_aid", this.getAppId());
        this.parameters.put("_mt", this.getMethod());
        String version = this.getVersion();
        if (!StrKit.isBlank(version)) {
            this.parameters.put("_version", version);
        }
        if (!StrKit.isBlank(requestMode = this.getRequestMode())) {
            this.parameters.put("_requestMode", requestMode);
        }
        Set<Map.Entry<String, Object>> es = this.parameters.entrySet();
        for (Map.Entry<String, Object> entry : es) {
            String k = entry.getKey();
            String v = (String)entry.getValue();
            if (unescape && k.equals("data")) {
                v = StringEscapeUtils.unescapeJava((String)v);
                v = UrlKit.encode(v, "UTF-8");
            }
            if ("_sig".equals(k)) continue;
            sb.append(k).append(v);
        }
        String sign = "";
        if ("rsa".equals(signatureMethod)) {
            sign = RSASignatureKit.sign(sb.toString(), this.getRsaPrivateKey());
        } else {
            sb.append(this.getApplicationSecret());
            sign = SignUtils.sign(signatureMethod, sb.toString());
        }
        this.setParameter("_sig", sign);
        this.setDebugInfo(sb.toString() + " => sign:" + sign);
    }

    public String getRequestURL() {
        boolean flag = this.isJsonUnescape();
        if (this.isIgnoreSignature()) {
            this.ignoreSign();
        } else {
            this.createSign(flag);
        }
        StringBuilder sb = new StringBuilder();
        String enc = this.getCharset();
        Set<Map.Entry<String, Object>> es = this.parameters.entrySet();
        for (Map.Entry<String, Object> entry : es) {
            String k = entry.getKey();
            String v = (String)entry.getValue();
            if (flag) {
                k = StringEscapeUtils.unescapeJava((String)k);
                v = StringEscapeUtils.unescapeJava((String)v);
            }
            try {
                sb.append(k).append("=").append(URLEncoder.encode(v, enc)).append("&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        String reqPars = sb.substring(0, sb.lastIndexOf("&"));
        return this.getGateUrl() + "?" + reqPars;
    }

    protected String getCharset() {
        return OvoParkUtils.getCharacterEncoding(this.request, this.response);
    }

    protected void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
    }

    public SortedMap<String, Object> getAllParameters() {
        return this.parameters;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public boolean isJsonUnescape() {
        return this.jsonUnescape;
    }

    public void setJsonUnescape(boolean jsonUnescape) {
        this.jsonUnescape = jsonUnescape;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRequestMode() {
        return this.requestMode;
    }

    public void setRequestMode(String requestMode) {
        this.requestMode = requestMode;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public String getRsaPrivateKey() {
        return this.rsaPrivateKey;
    }

    public void setRsaPrivateKey(String rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public boolean isIgnoreSignature() {
        return this.ignoreSignature;
    }

    public void setIgnoreSignature(boolean ignoreSignature) {
        this.ignoreSignature = ignoreSignature;
    }
}

