/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.apigetway.sdk.kit;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CurrentTimeMillisClockKit {
    private volatile long now = System.currentTimeMillis();

    private CurrentTimeMillisClockKit() {
        this.scheduleTick();
    }

    private void scheduleTick() {
        new ScheduledThreadPoolExecutor(1, runnable -> {
            Thread thread = new Thread(runnable, "current-time-millis");
            thread.setDaemon(true);
            return thread;
        }).scheduleAtFixedRate(() -> {
            this.now = System.currentTimeMillis();
        }, 1L, 1L, TimeUnit.MILLISECONDS);
    }

    public long now() {
        return this.now;
    }

    public static CurrentTimeMillisClockKit getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final CurrentTimeMillisClockKit INSTANCE = new CurrentTimeMillisClockKit();

        private SingletonHolder() {
        }
    }
}

