/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.apigetway.sdk.kit;

import com.ovopark.dc.apigetway.sdk.utils.Base64Util;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSASignatureKit {
    public static String sign(String content, String privateKey) {
        return RSASignatureKit.sign(content, privateKey, "UTF-8");
    }

    public static String sign(String content, String privateKey, String encode) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64Util.decode(privateKey));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey pk = keyFactory.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(pk);
            signature.update(content.getBytes());
            byte[] signedData = signature.sign();
            return Base64Util.encodeToString(signedData);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean doCheck(String content, String sign, String publicKey) {
        return RSASignatureKit.doCheck(content, sign, publicKey, "UTF-8");
    }

    public static boolean doCheck(String content, String sign, String publicKey, String encode) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = Base64Util.decode(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initVerify(pubKey);
            signature.update(content.getBytes(encode));
            return signature.verify(Base64Util.decode(sign));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

