/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.apigetway.sdk.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.ovopark.dc.apigetway.sdk.kit.PoJoKit;
import com.ovopark.dc.apigetway.sdk.kit.RSASignatureKit;
import com.ovopark.dc.apigetway.sdk.utils.ConvertUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public class SignUtils {
    public static final String _SM = "_sm";
    public static final String _SIG = "_sig";
    private static String debugInfo = "";

    public static String sign(Map<String, Object> paramValues, String sign, String sign_method) {
        return SignUtils.sign(paramValues, null, sign, sign_method);
    }

    public static String signJson(String json, String secret, String sign_method) {
        StringBuilder sb = new StringBuilder(secret);
        sb.append(json);
        sb.append(secret);
        return SignUtils.sign(sign_method, sb.toString());
    }

    public static String signPoJo(Object pojo, String secret, String sign_method) {
        Field[] fields;
        ConcurrentHashMap<String, Object> paramValues = new ConcurrentHashMap<String, Object>();
        Class<?> clazz = pojo.getClass();
        for (Field field : fields = PoJoKit.getNeedFields(clazz)) {
            try {
                String key;
                field.setAccessible(true);
                JSONField jsonField = field.getAnnotation(JSONField.class);
                String string = key = jsonField == null ? field.getName() : jsonField.name();
                if (key.equals(_SIG)) continue;
                Object value = field.get(pojo);
                if (value != null) {
                    if (key.equals(_SM)) {
                        sign_method = value.toString();
                    }
                    if (value instanceof List || value instanceof Map) {
                        value = JSON.toJSONString((Object)value);
                    }
                    paramValues.putIfAbsent(key, value);
                    continue;
                }
                paramValues.putIfAbsent(key, "");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        try {
            StringBuilder sb = new StringBuilder();
            ArrayList paramNames = new ArrayList(paramValues.size());
            paramNames.addAll(paramValues.keySet());
            Collections.sort(paramNames);
            sb.append(secret);
            for (String paramName : paramNames) {
                String value = ConvertUtils.toStr(paramValues.get(paramName), "");
                sb.append(paramName).append(value);
            }
            sb.append(secret);
            debugInfo = sb.toString();
            System.err.println("pojo debugInfo:" + debugInfo);
            byte[] digests = null;
            sign_method = sign_method.toLowerCase();
            digests = "sha1".equals(sign_method) ? SignUtils.getSHA1Digest(sb.toString()) : ("sha256".equals(sign_method) ? SignUtils.getSHA256Digest(sb.toString()) : ("sha512".equals(sign_method) ? SignUtils.getSHA512Digest(sb.toString()) : SignUtils.getMD5Digest(sb.toString())));
            return SignUtils.byte2hex(digests);
        }
        catch (IOException e) {
            throw new RuntimeException("apigetway sign error:" + e.getMessage());
        }
    }

    private static byte[] getSHA512Digest(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            bytes = md.digest(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse);
        }
        return bytes;
    }

    public static String sign(Map<String, Object> paramValues, List<String> ignoreParamNames, String secret, String sign_method) {
        try {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> paramNames = new ArrayList<String>(paramValues.size());
            paramNames.addAll(paramValues.keySet());
            if (ignoreParamNames != null && ignoreParamNames.size() > 0) {
                for (String ignoreParamName : ignoreParamNames) {
                    paramNames.remove(ignoreParamName);
                }
            }
            Collections.sort(paramNames);
            sb.append(secret);
            for (String paramName : paramNames) {
                String value = ConvertUtils.toStr(paramValues.get(paramName), "");
                sb.append(paramName).append(value);
            }
            sb.append(secret);
            debugInfo = sb.toString();
            System.err.println("map  debugInfo:" + debugInfo);
            byte[] digests = null;
            sign_method = sign_method.toLowerCase();
            digests = "sha1".equals(sign_method) ? SignUtils.getSHA1Digest(sb.toString()) : ("sha256".equals(sign_method) ? SignUtils.getSHA256Digest(sb.toString()) : SignUtils.getMD5Digest(sb.toString()));
            return SignUtils.byte2hex(digests);
        }
        catch (IOException e) {
            throw new RuntimeException("apigetway sign error:" + e.getMessage());
        }
    }

    public static String utf8Encoding(String value, String sourceCharsetName) {
        try {
            return new String(value.getBytes(sourceCharsetName), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] getSHA1Digest(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            bytes = md.digest(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse);
        }
        return bytes;
    }

    private static byte[] getSHA256Digest(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            bytes = md.digest(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse);
        }
        return bytes;
    }

    private static byte[] getMD5Digest(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse);
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().toUpperCase();
    }

    public static boolean checkSign(String sign, String applicationSecret, String signatureMethod, HttpServletRequest request) {
        HashMap<String, Object> needSignParams = new HashMap<String, Object>();
        Enumeration enume = request.getParameterNames();
        while (enume.hasMoreElements()) {
            String name = (String)enume.nextElement();
            if (name.equals(_SIG)) continue;
            String value = ConvertUtils.toStr(request.getParameter(name), "");
            needSignParams.put(name, value);
        }
        String signValue = SignUtils.sign(needSignParams, applicationSecret, signatureMethod);
        return signValue.equals(sign);
    }

    public static boolean checkSign(String sign, String applicationSecret, String signatureMethod, Object pojo) {
        String signValue = SignUtils.signPoJo(pojo, applicationSecret, signatureMethod);
        return signValue.equals(sign);
    }

    public static boolean checkSign(String sign, String applicationSecret, String signatureMethod, ConcurrentHashMap<String, String> requestMap) {
        HashMap<String, Object> needSignParams = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : requestMap.entrySet()) {
            String name = entry.getKey();
            if (name.equals(_SIG)) continue;
            needSignParams.put(name, entry.getValue());
        }
        String signValue = SignUtils.sign(needSignParams, applicationSecret, signatureMethod);
        return signValue.equals(sign);
    }

    public static String sign(String sign_method, String parmsvalue) {
        try {
            byte[] digests = null;
            sign_method = sign_method.toLowerCase();
            digests = "sha1".equals(sign_method) ? SignUtils.getSHA1Digest(parmsvalue) : ("sha256".equals(sign_method) ? SignUtils.getSHA256Digest(parmsvalue) : SignUtils.getMD5Digest(parmsvalue));
            return SignUtils.byte2hex(digests);
        }
        catch (IOException e) {
            throw new RuntimeException("apigetway sign error:" + e.getMessage());
        }
    }

    public static String getDebugInfo() {
        return debugInfo;
    }

    public static boolean checkRsaSign(String sign, String publicKey, ConcurrentHashMap<String, String> requestMap) {
        String content;
        HashMap<String, String> needSignParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : requestMap.entrySet()) {
            String name = entry.getKey();
            if (name.equals(_SIG)) continue;
            needSignParams.put(name, entry.getValue());
        }
        StringBuilder sb = new StringBuilder();
        ArrayList paramNames = new ArrayList(needSignParams.size());
        paramNames.addAll(needSignParams.keySet());
        Collections.sort(paramNames);
        for (String paramName : paramNames) {
            String value = ConvertUtils.toStr(needSignParams.get(paramName), "");
            sb.append(paramName).append(value);
        }
        debugInfo = content = sb.toString();
        System.err.println("rsa  debugInfo:" + debugInfo);
        return RSASignatureKit.doCheck(content, sign, publicKey);
    }
}

